<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.JointOwnerRow StructType
 * @subpackage Structs
 */
class Membership_JointOwnerRow extends AnyEntity
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The NameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnCard;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The OwnerNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OwnerNo;
    /**
     * The OwnerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerType;
    /**
     * The PrintCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintCard;
    /**
     * Constructor method for Membership.JointOwnerRow
     * @uses Membership_JointOwnerRow::setId()
     * @uses Membership_JointOwnerRow::setNameOnCard()
     * @uses Membership_JointOwnerRow::setOwnerId()
     * @uses Membership_JointOwnerRow::setOwnerNo()
     * @uses Membership_JointOwnerRow::setOwnerType()
     * @uses Membership_JointOwnerRow::setPrintCard()
     * @param string $id
     * @param string $nameOnCard
     * @param string $ownerId
     * @param int $ownerNo
     * @param string $ownerType
     * @param bool $printCard
     */
    public function __construct($id = null, $nameOnCard = null, $ownerId = null, $ownerNo = null, $ownerType = null, $printCard = null)
    {
        $this
            ->setId($id)
            ->setNameOnCard($nameOnCard)
            ->setOwnerId($ownerId)
            ->setOwnerNo($ownerNo)
            ->setOwnerType($ownerType)
            ->setPrintCard($printCard);
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Membership_JointOwnerRow
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get NameOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnCard()
    {
        return isset($this->NameOnCard) ? $this->NameOnCard : null;
    }
    /**
     * Set NameOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnCard
     * @return \patest\StructType\Membership_JointOwnerRow
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        if (is_null($nameOnCard) || (is_array($nameOnCard) && empty($nameOnCard))) {
            unset($this->NameOnCard);
        } else {
            $this->NameOnCard = $nameOnCard;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Membership_JointOwnerRow
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get OwnerNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOwnerNo()
    {
        return isset($this->OwnerNo) ? $this->OwnerNo : null;
    }
    /**
     * Set OwnerNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ownerNo
     * @return \patest\StructType\Membership_JointOwnerRow
     */
    public function setOwnerNo($ownerNo = null)
    {
        // validation for constraint: int
        if (!is_null($ownerNo) && !(is_int($ownerNo) || ctype_digit($ownerNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerNo, true), gettype($ownerNo)), __LINE__);
        }
        if (is_null($ownerNo) || (is_array($ownerNo) && empty($ownerNo))) {
            unset($this->OwnerNo);
        } else {
            $this->OwnerNo = $ownerNo;
        }
        return $this;
    }
    /**
     * Get OwnerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerType()
    {
        return isset($this->OwnerType) ? $this->OwnerType : null;
    }
    /**
     * Set OwnerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipMemberType::valueIsValid()
     * @uses \patest\EnumType\JointMembershipMemberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownerType
     * @return \patest\StructType\Membership_JointOwnerRow
     */
    public function setOwnerType($ownerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipMemberType::valueIsValid($ownerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipMemberType', is_array($ownerType) ? implode(', ', $ownerType) : var_export($ownerType, true), implode(', ', \patest\EnumType\JointMembershipMemberType::getValidValues())), __LINE__);
        }
        if (is_null($ownerType) || (is_array($ownerType) && empty($ownerType))) {
            unset($this->OwnerType);
        } else {
            $this->OwnerType = $ownerType;
        }
        return $this;
    }
    /**
     * Get PrintCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintCard()
    {
        return isset($this->PrintCard) ? $this->PrintCard : null;
    }
    /**
     * Set PrintCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printCard
     * @return \patest\StructType\Membership_JointOwnerRow
     */
    public function setPrintCard($printCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($printCard) && !is_bool($printCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printCard, true), gettype($printCard)), __LINE__);
        }
        if (is_null($printCard) || (is_array($printCard) && empty($printCard))) {
            unset($this->PrintCard);
        } else {
            $this->PrintCard = $printCard;
        }
        return $this;
    }
}
