<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchingGiftOption StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MatchingGiftOption
 * @subpackage Structs
 */
class MatchingGiftOption extends AbstractStructBase
{
    /**
     * The MatcherId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatcherId;
    /**
     * The MatcherName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MatcherName;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Minimum;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Percent;
    /**
     * The RelationshipsToSpecifiedClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMatchingGiftOptionRelationshipDetail
     */
    public $RelationshipsToSpecifiedClient;
    /**
     * The UpTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UpTo;
    /**
     * Constructor method for MatchingGiftOption
     * @uses MatchingGiftOption::setMatcherId()
     * @uses MatchingGiftOption::setMatcherName()
     * @uses MatchingGiftOption::setMinimum()
     * @uses MatchingGiftOption::setPercent()
     * @uses MatchingGiftOption::setRelationshipsToSpecifiedClient()
     * @uses MatchingGiftOption::setUpTo()
     * @param string $matcherId
     * @param string $matcherName
     * @param int $minimum
     * @param int $percent
     * @param \patest\ArrayType\ArrayOfMatchingGiftOptionRelationshipDetail $relationshipsToSpecifiedClient
     * @param int $upTo
     */
    public function __construct($matcherId = null, $matcherName = null, $minimum = null, $percent = null, \patest\ArrayType\ArrayOfMatchingGiftOptionRelationshipDetail $relationshipsToSpecifiedClient = null, $upTo = null)
    {
        $this
            ->setMatcherId($matcherId)
            ->setMatcherName($matcherName)
            ->setMinimum($minimum)
            ->setPercent($percent)
            ->setRelationshipsToSpecifiedClient($relationshipsToSpecifiedClient)
            ->setUpTo($upTo);
    }
    /**
     * Get MatcherId value
     * @return string|null
     */
    public function getMatcherId()
    {
        return $this->MatcherId;
    }
    /**
     * Set MatcherId value
     * @param string $matcherId
     * @return \patest\StructType\MatchingGiftOption
     */
    public function setMatcherId($matcherId = null)
    {
        // validation for constraint: string
        if (!is_null($matcherId) && !is_string($matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matcherId, true), gettype($matcherId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matcherId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matcherId, true)), __LINE__);
        }
        $this->MatcherId = $matcherId;
        return $this;
    }
    /**
     * Get MatcherName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatcherName()
    {
        return isset($this->MatcherName) ? $this->MatcherName : null;
    }
    /**
     * Set MatcherName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matcherName
     * @return \patest\StructType\MatchingGiftOption
     */
    public function setMatcherName($matcherName = null)
    {
        // validation for constraint: string
        if (!is_null($matcherName) && !is_string($matcherName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matcherName, true), gettype($matcherName)), __LINE__);
        }
        if (is_null($matcherName) || (is_array($matcherName) && empty($matcherName))) {
            unset($this->MatcherName);
        } else {
            $this->MatcherName = $matcherName;
        }
        return $this;
    }
    /**
     * Get Minimum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinimum()
    {
        return isset($this->Minimum) ? $this->Minimum : null;
    }
    /**
     * Set Minimum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minimum
     * @return \patest\StructType\MatchingGiftOption
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: int
        if (!is_null($minimum) && !(is_int($minimum) || ctype_digit($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        if (is_null($minimum) || (is_array($minimum) && empty($minimum))) {
            unset($this->Minimum);
        } else {
            $this->Minimum = $minimum;
        }
        return $this;
    }
    /**
     * Get Percent value
     * @return int|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param int $percent
     * @return \patest\StructType\MatchingGiftOption
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: int
        if (!is_null($percent) && !(is_int($percent) || ctype_digit($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get RelationshipsToSpecifiedClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMatchingGiftOptionRelationshipDetail|null
     */
    public function getRelationshipsToSpecifiedClient()
    {
        return isset($this->RelationshipsToSpecifiedClient) ? $this->RelationshipsToSpecifiedClient : null;
    }
    /**
     * Set RelationshipsToSpecifiedClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMatchingGiftOptionRelationshipDetail $relationshipsToSpecifiedClient
     * @return \patest\StructType\MatchingGiftOption
     */
    public function setRelationshipsToSpecifiedClient(\patest\ArrayType\ArrayOfMatchingGiftOptionRelationshipDetail $relationshipsToSpecifiedClient = null)
    {
        if (is_null($relationshipsToSpecifiedClient) || (is_array($relationshipsToSpecifiedClient) && empty($relationshipsToSpecifiedClient))) {
            unset($this->RelationshipsToSpecifiedClient);
        } else {
            $this->RelationshipsToSpecifiedClient = $relationshipsToSpecifiedClient;
        }
        return $this;
    }
    /**
     * Get UpTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUpTo()
    {
        return isset($this->UpTo) ? $this->UpTo : null;
    }
    /**
     * Set UpTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $upTo
     * @return \patest\StructType\MatchingGiftOption
     */
    public function setUpTo($upTo = null)
    {
        // validation for constraint: int
        if (!is_null($upTo) && !(is_int($upTo) || ctype_digit($upTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($upTo, true), gettype($upTo)), __LINE__);
        }
        if (is_null($upTo) || (is_array($upTo) && empty($upTo))) {
            unset($this->UpTo);
        } else {
            $this->UpTo = $upTo;
        }
        return $this;
    }
}
