<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchingDonationCandidateInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MatchingDonationCandidateInfo
 * @subpackage Structs
 */
class MatchingDonationCandidateInfo extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The ItemOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemOwnerId;
    /**
     * The ItemOwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemOwnerName;
    /**
     * The OriginalDonationFundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalDonationFundId;
    /**
     * The OriginalDonationFundName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OriginalDonationFundName;
    /**
     * The OriginalDonationTransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginalDonationTransactionDate;
    /**
     * The OriginalDonationTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginalDonationTransactionNumber;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for MatchingDonationCandidateInfo
     * @uses MatchingDonationCandidateInfo::setDetails()
     * @uses MatchingDonationCandidateInfo::setItemId()
     * @uses MatchingDonationCandidateInfo::setItemOwnerId()
     * @uses MatchingDonationCandidateInfo::setItemOwnerName()
     * @uses MatchingDonationCandidateInfo::setOriginalDonationFundId()
     * @uses MatchingDonationCandidateInfo::setOriginalDonationFundName()
     * @uses MatchingDonationCandidateInfo::setOriginalDonationTransactionDate()
     * @uses MatchingDonationCandidateInfo::setOriginalDonationTransactionNumber()
     * @uses MatchingDonationCandidateInfo::setTransactionGuid()
     * @uses MatchingDonationCandidateInfo::setValue()
     * @param string $details
     * @param int $itemId
     * @param string $itemOwnerId
     * @param string $itemOwnerName
     * @param string $originalDonationFundId
     * @param \patest\StructType\GlobalString $originalDonationFundName
     * @param string $originalDonationTransactionDate
     * @param int $originalDonationTransactionNumber
     * @param string $transactionGuid
     * @param float $value
     */
    public function __construct($details = null, $itemId = null, $itemOwnerId = null, $itemOwnerName = null, $originalDonationFundId = null, \patest\StructType\GlobalString $originalDonationFundName = null, $originalDonationTransactionDate = null, $originalDonationTransactionNumber = null, $transactionGuid = null, $value = null)
    {
        $this
            ->setDetails($details)
            ->setItemId($itemId)
            ->setItemOwnerId($itemOwnerId)
            ->setItemOwnerName($itemOwnerName)
            ->setOriginalDonationFundId($originalDonationFundId)
            ->setOriginalDonationFundName($originalDonationFundName)
            ->setOriginalDonationTransactionDate($originalDonationTransactionDate)
            ->setOriginalDonationTransactionNumber($originalDonationTransactionNumber)
            ->setTransactionGuid($transactionGuid)
            ->setValue($value);
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemOwnerId value
     * @return string|null
     */
    public function getItemOwnerId()
    {
        return $this->ItemOwnerId;
    }
    /**
     * Set ItemOwnerId value
     * @param string $itemOwnerId
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setItemOwnerId($itemOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($itemOwnerId) && !is_string($itemOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemOwnerId, true), gettype($itemOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemOwnerId, true)), __LINE__);
        }
        $this->ItemOwnerId = $itemOwnerId;
        return $this;
    }
    /**
     * Get ItemOwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemOwnerName()
    {
        return isset($this->ItemOwnerName) ? $this->ItemOwnerName : null;
    }
    /**
     * Set ItemOwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemOwnerName
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setItemOwnerName($itemOwnerName = null)
    {
        // validation for constraint: string
        if (!is_null($itemOwnerName) && !is_string($itemOwnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemOwnerName, true), gettype($itemOwnerName)), __LINE__);
        }
        if (is_null($itemOwnerName) || (is_array($itemOwnerName) && empty($itemOwnerName))) {
            unset($this->ItemOwnerName);
        } else {
            $this->ItemOwnerName = $itemOwnerName;
        }
        return $this;
    }
    /**
     * Get OriginalDonationFundId value
     * @return string|null
     */
    public function getOriginalDonationFundId()
    {
        return $this->OriginalDonationFundId;
    }
    /**
     * Set OriginalDonationFundId value
     * @param string $originalDonationFundId
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setOriginalDonationFundId($originalDonationFundId = null)
    {
        // validation for constraint: string
        if (!is_null($originalDonationFundId) && !is_string($originalDonationFundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDonationFundId, true), gettype($originalDonationFundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalDonationFundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalDonationFundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalDonationFundId, true)), __LINE__);
        }
        $this->OriginalDonationFundId = $originalDonationFundId;
        return $this;
    }
    /**
     * Get OriginalDonationFundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOriginalDonationFundName()
    {
        return isset($this->OriginalDonationFundName) ? $this->OriginalDonationFundName : null;
    }
    /**
     * Set OriginalDonationFundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $originalDonationFundName
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setOriginalDonationFundName(\patest\StructType\GlobalString $originalDonationFundName = null)
    {
        if (is_null($originalDonationFundName) || (is_array($originalDonationFundName) && empty($originalDonationFundName))) {
            unset($this->OriginalDonationFundName);
        } else {
            $this->OriginalDonationFundName = $originalDonationFundName;
        }
        return $this;
    }
    /**
     * Get OriginalDonationTransactionDate value
     * @return string|null
     */
    public function getOriginalDonationTransactionDate()
    {
        return $this->OriginalDonationTransactionDate;
    }
    /**
     * Set OriginalDonationTransactionDate value
     * @param string $originalDonationTransactionDate
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setOriginalDonationTransactionDate($originalDonationTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalDonationTransactionDate) && !is_string($originalDonationTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDonationTransactionDate, true), gettype($originalDonationTransactionDate)), __LINE__);
        }
        $this->OriginalDonationTransactionDate = $originalDonationTransactionDate;
        return $this;
    }
    /**
     * Get OriginalDonationTransactionNumber value
     * @return int|null
     */
    public function getOriginalDonationTransactionNumber()
    {
        return $this->OriginalDonationTransactionNumber;
    }
    /**
     * Set OriginalDonationTransactionNumber value
     * @param int $originalDonationTransactionNumber
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setOriginalDonationTransactionNumber($originalDonationTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($originalDonationTransactionNumber) && !(is_int($originalDonationTransactionNumber) || ctype_digit($originalDonationTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalDonationTransactionNumber, true), gettype($originalDonationTransactionNumber)), __LINE__);
        }
        $this->OriginalDonationTransactionNumber = $originalDonationTransactionNumber;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \patest\StructType\MatchingDonationCandidateInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
