<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ExecutedAppeal StructType
 * @subpackage Structs
 */
class Marketing_ExecutedAppeal extends DistributableEntity
{
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The AppealTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealTypeId;
    /**
     * The Bounced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Bounced;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The Clicked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Clicked;
    /**
     * The DataProtectionQuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataProtectionQuestionId;
    /**
     * The DynamicAttributeAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DynamicAttributeAction;
    /**
     * The DynamicClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicClientTypeId;
    /**
     * The DynamicPreferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicPreferenceId;
    /**
     * The ElementTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElementTypeName;
    /**
     * The ExecutionProcessTableName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionProcessTableName;
    /**
     * The IncludeManuallyAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeManuallyAttributes;
    /**
     * The IsApplyDynamicAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApplyDynamicAttributes;
    /**
     * The IsManuallyExecuted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsManuallyExecuted;
    /**
     * The IsStoreResultsInHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStoreResultsInHistory;
    /**
     * The NextFeedbackTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextFeedbackTime;
    /**
     * The NextSummaryFeedbackTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextSummaryFeedbackTime;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The ProviderSetup
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderSetup;
    /**
     * The Purchased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Purchased;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The Read
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Read;
    /**
     * The RecipientFailures
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecipientFailures;
    /**
     * The Recipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Recipients;
    /**
     * The RunOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunOn;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ThirdPartyReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThirdPartyReference;
    /**
     * The Unsubscribed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Unsubscribed;
    /**
     * Constructor method for Marketing.ExecutedAppeal
     * @uses Marketing_ExecutedAppeal::setAppealId()
     * @uses Marketing_ExecutedAppeal::setAppealTypeId()
     * @uses Marketing_ExecutedAppeal::setBounced()
     * @uses Marketing_ExecutedAppeal::setCampaignId()
     * @uses Marketing_ExecutedAppeal::setClicked()
     * @uses Marketing_ExecutedAppeal::setDataProtectionQuestionId()
     * @uses Marketing_ExecutedAppeal::setDynamicAttributeAction()
     * @uses Marketing_ExecutedAppeal::setDynamicClientTypeId()
     * @uses Marketing_ExecutedAppeal::setDynamicPreferenceId()
     * @uses Marketing_ExecutedAppeal::setElementTypeName()
     * @uses Marketing_ExecutedAppeal::setExecutionProcessTableName()
     * @uses Marketing_ExecutedAppeal::setIncludeManuallyAttributes()
     * @uses Marketing_ExecutedAppeal::setIsApplyDynamicAttributes()
     * @uses Marketing_ExecutedAppeal::setIsManuallyExecuted()
     * @uses Marketing_ExecutedAppeal::setIsStoreResultsInHistory()
     * @uses Marketing_ExecutedAppeal::setNextFeedbackTime()
     * @uses Marketing_ExecutedAppeal::setNextSummaryFeedbackTime()
     * @uses Marketing_ExecutedAppeal::setProvider()
     * @uses Marketing_ExecutedAppeal::setProviderSetup()
     * @uses Marketing_ExecutedAppeal::setPurchased()
     * @uses Marketing_ExecutedAppeal::setQueryId()
     * @uses Marketing_ExecutedAppeal::setRead()
     * @uses Marketing_ExecutedAppeal::setRecipientFailures()
     * @uses Marketing_ExecutedAppeal::setRecipients()
     * @uses Marketing_ExecutedAppeal::setRunOn()
     * @uses Marketing_ExecutedAppeal::setStatus()
     * @uses Marketing_ExecutedAppeal::setThirdPartyReference()
     * @uses Marketing_ExecutedAppeal::setUnsubscribed()
     * @param string $appealId
     * @param string $appealTypeId
     * @param int $bounced
     * @param string $campaignId
     * @param int $clicked
     * @param string $dataProtectionQuestionId
     * @param string $dynamicAttributeAction
     * @param string $dynamicClientTypeId
     * @param string $dynamicPreferenceId
     * @param string $elementTypeName
     * @param string $executionProcessTableName
     * @param bool $includeManuallyAttributes
     * @param bool $isApplyDynamicAttributes
     * @param bool $isManuallyExecuted
     * @param bool $isStoreResultsInHistory
     * @param string $nextFeedbackTime
     * @param string $nextSummaryFeedbackTime
     * @param string $provider
     * @param string $providerSetup
     * @param int $purchased
     * @param string $queryId
     * @param int $read
     * @param int $recipientFailures
     * @param int $recipients
     * @param string $runOn
     * @param string $status
     * @param string $thirdPartyReference
     * @param int $unsubscribed
     */
    public function __construct($appealId = null, $appealTypeId = null, $bounced = null, $campaignId = null, $clicked = null, $dataProtectionQuestionId = null, $dynamicAttributeAction = null, $dynamicClientTypeId = null, $dynamicPreferenceId = null, $elementTypeName = null, $executionProcessTableName = null, $includeManuallyAttributes = null, $isApplyDynamicAttributes = null, $isManuallyExecuted = null, $isStoreResultsInHistory = null, $nextFeedbackTime = null, $nextSummaryFeedbackTime = null, $provider = null, $providerSetup = null, $purchased = null, $queryId = null, $read = null, $recipientFailures = null, $recipients = null, $runOn = null, $status = null, $thirdPartyReference = null, $unsubscribed = null)
    {
        $this
            ->setAppealId($appealId)
            ->setAppealTypeId($appealTypeId)
            ->setBounced($bounced)
            ->setCampaignId($campaignId)
            ->setClicked($clicked)
            ->setDataProtectionQuestionId($dataProtectionQuestionId)
            ->setDynamicAttributeAction($dynamicAttributeAction)
            ->setDynamicClientTypeId($dynamicClientTypeId)
            ->setDynamicPreferenceId($dynamicPreferenceId)
            ->setElementTypeName($elementTypeName)
            ->setExecutionProcessTableName($executionProcessTableName)
            ->setIncludeManuallyAttributes($includeManuallyAttributes)
            ->setIsApplyDynamicAttributes($isApplyDynamicAttributes)
            ->setIsManuallyExecuted($isManuallyExecuted)
            ->setIsStoreResultsInHistory($isStoreResultsInHistory)
            ->setNextFeedbackTime($nextFeedbackTime)
            ->setNextSummaryFeedbackTime($nextSummaryFeedbackTime)
            ->setProvider($provider)
            ->setProviderSetup($providerSetup)
            ->setPurchased($purchased)
            ->setQueryId($queryId)
            ->setRead($read)
            ->setRecipientFailures($recipientFailures)
            ->setRecipients($recipients)
            ->setRunOn($runOn)
            ->setStatus($status)
            ->setThirdPartyReference($thirdPartyReference)
            ->setUnsubscribed($unsubscribed);
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get AppealTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealTypeId()
    {
        return isset($this->AppealTypeId) ? $this->AppealTypeId : null;
    }
    /**
     * Set AppealTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealTypeId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setAppealTypeId($appealTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($appealTypeId) && !is_string($appealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealTypeId, true), gettype($appealTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealTypeId, true)), __LINE__);
        }
        if (is_null($appealTypeId) || (is_array($appealTypeId) && empty($appealTypeId))) {
            unset($this->AppealTypeId);
        } else {
            $this->AppealTypeId = $appealTypeId;
        }
        return $this;
    }
    /**
     * Get Bounced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBounced()
    {
        return isset($this->Bounced) ? $this->Bounced : null;
    }
    /**
     * Set Bounced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bounced
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setBounced($bounced = null)
    {
        // validation for constraint: int
        if (!is_null($bounced) && !(is_int($bounced) || ctype_digit($bounced))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bounced, true), gettype($bounced)), __LINE__);
        }
        if (is_null($bounced) || (is_array($bounced) && empty($bounced))) {
            unset($this->Bounced);
        } else {
            $this->Bounced = $bounced;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get Clicked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClicked()
    {
        return isset($this->Clicked) ? $this->Clicked : null;
    }
    /**
     * Set Clicked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clicked
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setClicked($clicked = null)
    {
        // validation for constraint: int
        if (!is_null($clicked) && !(is_int($clicked) || ctype_digit($clicked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clicked, true), gettype($clicked)), __LINE__);
        }
        if (is_null($clicked) || (is_array($clicked) && empty($clicked))) {
            unset($this->Clicked);
        } else {
            $this->Clicked = $clicked;
        }
        return $this;
    }
    /**
     * Get DataProtectionQuestionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtectionQuestionId()
    {
        return isset($this->DataProtectionQuestionId) ? $this->DataProtectionQuestionId : null;
    }
    /**
     * Set DataProtectionQuestionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtectionQuestionId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setDataProtectionQuestionId($dataProtectionQuestionId = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtectionQuestionId) && !is_string($dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtectionQuestionId, true), gettype($dataProtectionQuestionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataProtectionQuestionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataProtectionQuestionId, true)), __LINE__);
        }
        if (is_null($dataProtectionQuestionId) || (is_array($dataProtectionQuestionId) && empty($dataProtectionQuestionId))) {
            unset($this->DataProtectionQuestionId);
        } else {
            $this->DataProtectionQuestionId = $dataProtectionQuestionId;
        }
        return $this;
    }
    /**
     * Get DynamicAttributeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAttributeAction()
    {
        return isset($this->DynamicAttributeAction) ? $this->DynamicAttributeAction : null;
    }
    /**
     * Set DynamicAttributeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DynamicAttributeAction::valueIsValid()
     * @uses \patest\EnumType\DynamicAttributeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicAttributeAction
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setDynamicAttributeAction($dynamicAttributeAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DynamicAttributeAction::valueIsValid($dynamicAttributeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DynamicAttributeAction', is_array($dynamicAttributeAction) ? implode(', ', $dynamicAttributeAction) : var_export($dynamicAttributeAction, true), implode(', ', \patest\EnumType\DynamicAttributeAction::getValidValues())), __LINE__);
        }
        if (is_null($dynamicAttributeAction) || (is_array($dynamicAttributeAction) && empty($dynamicAttributeAction))) {
            unset($this->DynamicAttributeAction);
        } else {
            $this->DynamicAttributeAction = $dynamicAttributeAction;
        }
        return $this;
    }
    /**
     * Get DynamicClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicClientTypeId()
    {
        return isset($this->DynamicClientTypeId) ? $this->DynamicClientTypeId : null;
    }
    /**
     * Set DynamicClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicClientTypeId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setDynamicClientTypeId($dynamicClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicClientTypeId) && !is_string($dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicClientTypeId, true), gettype($dynamicClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicClientTypeId, true)), __LINE__);
        }
        if (is_null($dynamicClientTypeId) || (is_array($dynamicClientTypeId) && empty($dynamicClientTypeId))) {
            unset($this->DynamicClientTypeId);
        } else {
            $this->DynamicClientTypeId = $dynamicClientTypeId;
        }
        return $this;
    }
    /**
     * Get DynamicPreferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicPreferenceId()
    {
        return isset($this->DynamicPreferenceId) ? $this->DynamicPreferenceId : null;
    }
    /**
     * Set DynamicPreferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicPreferenceId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setDynamicPreferenceId($dynamicPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicPreferenceId) && !is_string($dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicPreferenceId, true), gettype($dynamicPreferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicPreferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicPreferenceId, true)), __LINE__);
        }
        if (is_null($dynamicPreferenceId) || (is_array($dynamicPreferenceId) && empty($dynamicPreferenceId))) {
            unset($this->DynamicPreferenceId);
        } else {
            $this->DynamicPreferenceId = $dynamicPreferenceId;
        }
        return $this;
    }
    /**
     * Get ElementTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementTypeName()
    {
        return isset($this->ElementTypeName) ? $this->ElementTypeName : null;
    }
    /**
     * Set ElementTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementTypeName
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setElementTypeName($elementTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($elementTypeName) && !is_string($elementTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementTypeName, true), gettype($elementTypeName)), __LINE__);
        }
        if (is_null($elementTypeName) || (is_array($elementTypeName) && empty($elementTypeName))) {
            unset($this->ElementTypeName);
        } else {
            $this->ElementTypeName = $elementTypeName;
        }
        return $this;
    }
    /**
     * Get ExecutionProcessTableName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionProcessTableName()
    {
        return isset($this->ExecutionProcessTableName) ? $this->ExecutionProcessTableName : null;
    }
    /**
     * Set ExecutionProcessTableName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionProcessTableName
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setExecutionProcessTableName($executionProcessTableName = null)
    {
        // validation for constraint: string
        if (!is_null($executionProcessTableName) && !is_string($executionProcessTableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionProcessTableName, true), gettype($executionProcessTableName)), __LINE__);
        }
        if (is_null($executionProcessTableName) || (is_array($executionProcessTableName) && empty($executionProcessTableName))) {
            unset($this->ExecutionProcessTableName);
        } else {
            $this->ExecutionProcessTableName = $executionProcessTableName;
        }
        return $this;
    }
    /**
     * Get IncludeManuallyAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeManuallyAttributes()
    {
        return isset($this->IncludeManuallyAttributes) ? $this->IncludeManuallyAttributes : null;
    }
    /**
     * Set IncludeManuallyAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeManuallyAttributes
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setIncludeManuallyAttributes($includeManuallyAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeManuallyAttributes) && !is_bool($includeManuallyAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeManuallyAttributes, true), gettype($includeManuallyAttributes)), __LINE__);
        }
        if (is_null($includeManuallyAttributes) || (is_array($includeManuallyAttributes) && empty($includeManuallyAttributes))) {
            unset($this->IncludeManuallyAttributes);
        } else {
            $this->IncludeManuallyAttributes = $includeManuallyAttributes;
        }
        return $this;
    }
    /**
     * Get IsApplyDynamicAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApplyDynamicAttributes()
    {
        return isset($this->IsApplyDynamicAttributes) ? $this->IsApplyDynamicAttributes : null;
    }
    /**
     * Set IsApplyDynamicAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApplyDynamicAttributes
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setIsApplyDynamicAttributes($isApplyDynamicAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApplyDynamicAttributes) && !is_bool($isApplyDynamicAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApplyDynamicAttributes, true), gettype($isApplyDynamicAttributes)), __LINE__);
        }
        if (is_null($isApplyDynamicAttributes) || (is_array($isApplyDynamicAttributes) && empty($isApplyDynamicAttributes))) {
            unset($this->IsApplyDynamicAttributes);
        } else {
            $this->IsApplyDynamicAttributes = $isApplyDynamicAttributes;
        }
        return $this;
    }
    /**
     * Get IsManuallyExecuted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsManuallyExecuted()
    {
        return isset($this->IsManuallyExecuted) ? $this->IsManuallyExecuted : null;
    }
    /**
     * Set IsManuallyExecuted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isManuallyExecuted
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setIsManuallyExecuted($isManuallyExecuted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManuallyExecuted) && !is_bool($isManuallyExecuted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManuallyExecuted, true), gettype($isManuallyExecuted)), __LINE__);
        }
        if (is_null($isManuallyExecuted) || (is_array($isManuallyExecuted) && empty($isManuallyExecuted))) {
            unset($this->IsManuallyExecuted);
        } else {
            $this->IsManuallyExecuted = $isManuallyExecuted;
        }
        return $this;
    }
    /**
     * Get IsStoreResultsInHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStoreResultsInHistory()
    {
        return isset($this->IsStoreResultsInHistory) ? $this->IsStoreResultsInHistory : null;
    }
    /**
     * Set IsStoreResultsInHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStoreResultsInHistory
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setIsStoreResultsInHistory($isStoreResultsInHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStoreResultsInHistory) && !is_bool($isStoreResultsInHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStoreResultsInHistory, true), gettype($isStoreResultsInHistory)), __LINE__);
        }
        if (is_null($isStoreResultsInHistory) || (is_array($isStoreResultsInHistory) && empty($isStoreResultsInHistory))) {
            unset($this->IsStoreResultsInHistory);
        } else {
            $this->IsStoreResultsInHistory = $isStoreResultsInHistory;
        }
        return $this;
    }
    /**
     * Get NextFeedbackTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextFeedbackTime()
    {
        return isset($this->NextFeedbackTime) ? $this->NextFeedbackTime : null;
    }
    /**
     * Set NextFeedbackTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextFeedbackTime
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setNextFeedbackTime($nextFeedbackTime = null)
    {
        // validation for constraint: string
        if (!is_null($nextFeedbackTime) && !is_string($nextFeedbackTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextFeedbackTime, true), gettype($nextFeedbackTime)), __LINE__);
        }
        if (is_null($nextFeedbackTime) || (is_array($nextFeedbackTime) && empty($nextFeedbackTime))) {
            unset($this->NextFeedbackTime);
        } else {
            $this->NextFeedbackTime = $nextFeedbackTime;
        }
        return $this;
    }
    /**
     * Get NextSummaryFeedbackTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextSummaryFeedbackTime()
    {
        return isset($this->NextSummaryFeedbackTime) ? $this->NextSummaryFeedbackTime : null;
    }
    /**
     * Set NextSummaryFeedbackTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextSummaryFeedbackTime
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setNextSummaryFeedbackTime($nextSummaryFeedbackTime = null)
    {
        // validation for constraint: string
        if (!is_null($nextSummaryFeedbackTime) && !is_string($nextSummaryFeedbackTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextSummaryFeedbackTime, true), gettype($nextSummaryFeedbackTime)), __LINE__);
        }
        if (is_null($nextSummaryFeedbackTime) || (is_array($nextSummaryFeedbackTime) && empty($nextSummaryFeedbackTime))) {
            unset($this->NextSummaryFeedbackTime);
        } else {
            $this->NextSummaryFeedbackTime = $nextSummaryFeedbackTime;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get ProviderSetup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSetup()
    {
        return isset($this->ProviderSetup) ? $this->ProviderSetup : null;
    }
    /**
     * Set ProviderSetup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSetup
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setProviderSetup($providerSetup = null)
    {
        // validation for constraint: string
        if (!is_null($providerSetup) && !is_string($providerSetup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSetup, true), gettype($providerSetup)), __LINE__);
        }
        if (is_null($providerSetup) || (is_array($providerSetup) && empty($providerSetup))) {
            unset($this->ProviderSetup);
        } else {
            $this->ProviderSetup = $providerSetup;
        }
        return $this;
    }
    /**
     * Get Purchased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPurchased()
    {
        return isset($this->Purchased) ? $this->Purchased : null;
    }
    /**
     * Set Purchased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $purchased
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setPurchased($purchased = null)
    {
        // validation for constraint: int
        if (!is_null($purchased) && !(is_int($purchased) || ctype_digit($purchased))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purchased, true), gettype($purchased)), __LINE__);
        }
        if (is_null($purchased) || (is_array($purchased) && empty($purchased))) {
            unset($this->Purchased);
        } else {
            $this->Purchased = $purchased;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get Read value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRead()
    {
        return isset($this->Read) ? $this->Read : null;
    }
    /**
     * Set Read value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $read
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setRead($read = null)
    {
        // validation for constraint: int
        if (!is_null($read) && !(is_int($read) || ctype_digit($read))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($read, true), gettype($read)), __LINE__);
        }
        if (is_null($read) || (is_array($read) && empty($read))) {
            unset($this->Read);
        } else {
            $this->Read = $read;
        }
        return $this;
    }
    /**
     * Get RecipientFailures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecipientFailures()
    {
        return isset($this->RecipientFailures) ? $this->RecipientFailures : null;
    }
    /**
     * Set RecipientFailures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recipientFailures
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setRecipientFailures($recipientFailures = null)
    {
        // validation for constraint: int
        if (!is_null($recipientFailures) && !(is_int($recipientFailures) || ctype_digit($recipientFailures))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recipientFailures, true), gettype($recipientFailures)), __LINE__);
        }
        if (is_null($recipientFailures) || (is_array($recipientFailures) && empty($recipientFailures))) {
            unset($this->RecipientFailures);
        } else {
            $this->RecipientFailures = $recipientFailures;
        }
        return $this;
    }
    /**
     * Get Recipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecipients()
    {
        return isset($this->Recipients) ? $this->Recipients : null;
    }
    /**
     * Set Recipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recipients
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setRecipients($recipients = null)
    {
        // validation for constraint: int
        if (!is_null($recipients) && !(is_int($recipients) || ctype_digit($recipients))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recipients, true), gettype($recipients)), __LINE__);
        }
        if (is_null($recipients) || (is_array($recipients) && empty($recipients))) {
            unset($this->Recipients);
        } else {
            $this->Recipients = $recipients;
        }
        return $this;
    }
    /**
     * Get RunOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunOn()
    {
        return isset($this->RunOn) ? $this->RunOn : null;
    }
    /**
     * Set RunOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runOn
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setRunOn($runOn = null)
    {
        // validation for constraint: string
        if (!is_null($runOn) && !is_string($runOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runOn, true), gettype($runOn)), __LINE__);
        }
        if (is_null($runOn) || (is_array($runOn) && empty($runOn))) {
            unset($this->RunOn);
        } else {
            $this->RunOn = $runOn;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExecutedAppealStatus::valueIsValid()
     * @uses \patest\EnumType\ExecutedAppealStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExecutedAppealStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExecutedAppealStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ExecutedAppealStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ThirdPartyReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThirdPartyReference()
    {
        return isset($this->ThirdPartyReference) ? $this->ThirdPartyReference : null;
    }
    /**
     * Set ThirdPartyReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thirdPartyReference
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setThirdPartyReference($thirdPartyReference = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyReference) && !is_string($thirdPartyReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyReference, true), gettype($thirdPartyReference)), __LINE__);
        }
        if (is_null($thirdPartyReference) || (is_array($thirdPartyReference) && empty($thirdPartyReference))) {
            unset($this->ThirdPartyReference);
        } else {
            $this->ThirdPartyReference = $thirdPartyReference;
        }
        return $this;
    }
    /**
     * Get Unsubscribed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnsubscribed()
    {
        return isset($this->Unsubscribed) ? $this->Unsubscribed : null;
    }
    /**
     * Set Unsubscribed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unsubscribed
     * @return \patest\StructType\Marketing_ExecutedAppeal
     */
    public function setUnsubscribed($unsubscribed = null)
    {
        // validation for constraint: int
        if (!is_null($unsubscribed) && !(is_int($unsubscribed) || ctype_digit($unsubscribed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unsubscribed, true), gettype($unsubscribed)), __LINE__);
        }
        if (is_null($unsubscribed) || (is_array($unsubscribed) && empty($unsubscribed))) {
            unset($this->Unsubscribed);
        } else {
            $this->Unsubscribed = $unsubscribed;
        }
        return $this;
    }
}
