<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ExecutableAppeal StructType
 * @subpackage Structs
 */
class Marketing_ExecutableAppeal extends Marketing_Appeal
{
    /**
     * The CostPerClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CostPerClient;
    /**
     * The DataProtectionQuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataProtectionQuestionId;
    /**
     * The IsApplyDynamicAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApplyDynamicAttributes;
    /**
     * The IsStoreResultsInHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStoreResultsInHistory;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * Constructor method for Marketing.ExecutableAppeal
     * @uses Marketing_ExecutableAppeal::setCostPerClient()
     * @uses Marketing_ExecutableAppeal::setDataProtectionQuestionId()
     * @uses Marketing_ExecutableAppeal::setIsApplyDynamicAttributes()
     * @uses Marketing_ExecutableAppeal::setIsStoreResultsInHistory()
     * @uses Marketing_ExecutableAppeal::setQueryId()
     * @param float $costPerClient
     * @param string $dataProtectionQuestionId
     * @param bool $isApplyDynamicAttributes
     * @param bool $isStoreResultsInHistory
     * @param string $queryId
     */
    public function __construct($costPerClient = null, $dataProtectionQuestionId = null, $isApplyDynamicAttributes = null, $isStoreResultsInHistory = null, $queryId = null)
    {
        $this
            ->setCostPerClient($costPerClient)
            ->setDataProtectionQuestionId($dataProtectionQuestionId)
            ->setIsApplyDynamicAttributes($isApplyDynamicAttributes)
            ->setIsStoreResultsInHistory($isStoreResultsInHistory)
            ->setQueryId($queryId);
    }
    /**
     * Get CostPerClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCostPerClient()
    {
        return isset($this->CostPerClient) ? $this->CostPerClient : null;
    }
    /**
     * Set CostPerClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $costPerClient
     * @return \patest\StructType\Marketing_ExecutableAppeal
     */
    public function setCostPerClient($costPerClient = null)
    {
        // validation for constraint: float
        if (!is_null($costPerClient) && !(is_float($costPerClient) || is_numeric($costPerClient))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costPerClient, true), gettype($costPerClient)), __LINE__);
        }
        if (is_null($costPerClient) || (is_array($costPerClient) && empty($costPerClient))) {
            unset($this->CostPerClient);
        } else {
            $this->CostPerClient = $costPerClient;
        }
        return $this;
    }
    /**
     * Get DataProtectionQuestionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtectionQuestionId()
    {
        return isset($this->DataProtectionQuestionId) ? $this->DataProtectionQuestionId : null;
    }
    /**
     * Set DataProtectionQuestionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtectionQuestionId
     * @return \patest\StructType\Marketing_ExecutableAppeal
     */
    public function setDataProtectionQuestionId($dataProtectionQuestionId = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtectionQuestionId) && !is_string($dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtectionQuestionId, true), gettype($dataProtectionQuestionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataProtectionQuestionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataProtectionQuestionId, true)), __LINE__);
        }
        if (is_null($dataProtectionQuestionId) || (is_array($dataProtectionQuestionId) && empty($dataProtectionQuestionId))) {
            unset($this->DataProtectionQuestionId);
        } else {
            $this->DataProtectionQuestionId = $dataProtectionQuestionId;
        }
        return $this;
    }
    /**
     * Get IsApplyDynamicAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApplyDynamicAttributes()
    {
        return isset($this->IsApplyDynamicAttributes) ? $this->IsApplyDynamicAttributes : null;
    }
    /**
     * Set IsApplyDynamicAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApplyDynamicAttributes
     * @return \patest\StructType\Marketing_ExecutableAppeal
     */
    public function setIsApplyDynamicAttributes($isApplyDynamicAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApplyDynamicAttributes) && !is_bool($isApplyDynamicAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApplyDynamicAttributes, true), gettype($isApplyDynamicAttributes)), __LINE__);
        }
        if (is_null($isApplyDynamicAttributes) || (is_array($isApplyDynamicAttributes) && empty($isApplyDynamicAttributes))) {
            unset($this->IsApplyDynamicAttributes);
        } else {
            $this->IsApplyDynamicAttributes = $isApplyDynamicAttributes;
        }
        return $this;
    }
    /**
     * Get IsStoreResultsInHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStoreResultsInHistory()
    {
        return isset($this->IsStoreResultsInHistory) ? $this->IsStoreResultsInHistory : null;
    }
    /**
     * Set IsStoreResultsInHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStoreResultsInHistory
     * @return \patest\StructType\Marketing_ExecutableAppeal
     */
    public function setIsStoreResultsInHistory($isStoreResultsInHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStoreResultsInHistory) && !is_bool($isStoreResultsInHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStoreResultsInHistory, true), gettype($isStoreResultsInHistory)), __LINE__);
        }
        if (is_null($isStoreResultsInHistory) || (is_array($isStoreResultsInHistory) && empty($isStoreResultsInHistory))) {
            unset($this->IsStoreResultsInHistory);
        } else {
            $this->IsStoreResultsInHistory = $isStoreResultsInHistory;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Marketing_ExecutableAppeal
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
}
