<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.CommunicationChannel StructType
 * @subpackage Structs
 */
class Marketing_CommunicationChannel extends DistributableEntity
{
    /**
     * The AppealTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealTypeId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Marketing.CommunicationChannel
     * @uses Marketing_CommunicationChannel::setAppealTypeId()
     * @uses Marketing_CommunicationChannel::setName()
     * @param string $appealTypeId
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($appealTypeId = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setAppealTypeId($appealTypeId)
            ->setName($name);
    }
    /**
     * Get AppealTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealTypeId()
    {
        return isset($this->AppealTypeId) ? $this->AppealTypeId : null;
    }
    /**
     * Set AppealTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealTypeId
     * @return \patest\StructType\Marketing_CommunicationChannel
     */
    public function setAppealTypeId($appealTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($appealTypeId) && !is_string($appealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealTypeId, true), gettype($appealTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealTypeId, true)), __LINE__);
        }
        if (is_null($appealTypeId) || (is_array($appealTypeId) && empty($appealTypeId))) {
            unset($this->AppealTypeId);
        } else {
            $this->AppealTypeId = $appealTypeId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Marketing_CommunicationChannel
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
