<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManipulateChunkedRetrieve-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ManipulateChunkedRetrieve-Request
 * @subpackage Structs
 */
class ManipulateChunkedRetrieve_Request extends AbstractStructBase
{
    /**
     * The AdditionalFilterClause
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalFilterClause;
    /**
     * The InitialChunkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InitialChunkSize;
    /**
     * The ManipulationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ManipulationType;
    /**
     * The QueryToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryToken;
    /**
     * The ShouldCreateNewToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldCreateNewToken;
    /**
     * The ShouldIncludeCountTotalMatchingRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldIncludeCountTotalMatchingRows;
    /**
     * The SortingClause
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SortingClause;
    /**
     * Constructor method for ManipulateChunkedRetrieve-Request
     * @uses ManipulateChunkedRetrieve_Request::setAdditionalFilterClause()
     * @uses ManipulateChunkedRetrieve_Request::setInitialChunkSize()
     * @uses ManipulateChunkedRetrieve_Request::setManipulationType()
     * @uses ManipulateChunkedRetrieve_Request::setQueryToken()
     * @uses ManipulateChunkedRetrieve_Request::setShouldCreateNewToken()
     * @uses ManipulateChunkedRetrieve_Request::setShouldIncludeCountTotalMatchingRows()
     * @uses ManipulateChunkedRetrieve_Request::setSortingClause()
     * @param string $additionalFilterClause
     * @param int $initialChunkSize
     * @param string $manipulationType
     * @param string $queryToken
     * @param bool $shouldCreateNewToken
     * @param bool $shouldIncludeCountTotalMatchingRows
     * @param string $sortingClause
     */
    public function __construct($additionalFilterClause = null, $initialChunkSize = null, $manipulationType = null, $queryToken = null, $shouldCreateNewToken = null, $shouldIncludeCountTotalMatchingRows = null, $sortingClause = null)
    {
        $this
            ->setAdditionalFilterClause($additionalFilterClause)
            ->setInitialChunkSize($initialChunkSize)
            ->setManipulationType($manipulationType)
            ->setQueryToken($queryToken)
            ->setShouldCreateNewToken($shouldCreateNewToken)
            ->setShouldIncludeCountTotalMatchingRows($shouldIncludeCountTotalMatchingRows)
            ->setSortingClause($sortingClause);
    }
    /**
     * Get AdditionalFilterClause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalFilterClause()
    {
        return isset($this->AdditionalFilterClause) ? $this->AdditionalFilterClause : null;
    }
    /**
     * Set AdditionalFilterClause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalFilterClause
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setAdditionalFilterClause($additionalFilterClause = null)
    {
        // validation for constraint: string
        if (!is_null($additionalFilterClause) && !is_string($additionalFilterClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalFilterClause, true), gettype($additionalFilterClause)), __LINE__);
        }
        if (is_null($additionalFilterClause) || (is_array($additionalFilterClause) && empty($additionalFilterClause))) {
            unset($this->AdditionalFilterClause);
        } else {
            $this->AdditionalFilterClause = $additionalFilterClause;
        }
        return $this;
    }
    /**
     * Get InitialChunkSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInitialChunkSize()
    {
        return isset($this->InitialChunkSize) ? $this->InitialChunkSize : null;
    }
    /**
     * Set InitialChunkSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $initialChunkSize
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setInitialChunkSize($initialChunkSize = null)
    {
        // validation for constraint: int
        if (!is_null($initialChunkSize) && !(is_int($initialChunkSize) || ctype_digit($initialChunkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initialChunkSize, true), gettype($initialChunkSize)), __LINE__);
        }
        if (is_null($initialChunkSize) || (is_array($initialChunkSize) && empty($initialChunkSize))) {
            unset($this->InitialChunkSize);
        } else {
            $this->InitialChunkSize = $initialChunkSize;
        }
        return $this;
    }
    /**
     * Get ManipulationType value
     * @return string|null
     */
    public function getManipulationType()
    {
        return $this->ManipulationType;
    }
    /**
     * Set ManipulationType value
     * @uses \patest\EnumType\ManipulationType::valueIsValid()
     * @uses \patest\EnumType\ManipulationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $manipulationType
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setManipulationType($manipulationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ManipulationType::valueIsValid($manipulationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ManipulationType', is_array($manipulationType) ? implode(', ', $manipulationType) : var_export($manipulationType, true), implode(', ', \patest\EnumType\ManipulationType::getValidValues())), __LINE__);
        }
        $this->ManipulationType = $manipulationType;
        return $this;
    }
    /**
     * Get QueryToken value
     * @return string|null
     */
    public function getQueryToken()
    {
        return $this->QueryToken;
    }
    /**
     * Set QueryToken value
     * @param string $queryToken
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setQueryToken($queryToken = null)
    {
        // validation for constraint: string
        if (!is_null($queryToken) && !is_string($queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryToken, true), gettype($queryToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryToken, true)), __LINE__);
        }
        $this->QueryToken = $queryToken;
        return $this;
    }
    /**
     * Get ShouldCreateNewToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldCreateNewToken()
    {
        return isset($this->ShouldCreateNewToken) ? $this->ShouldCreateNewToken : null;
    }
    /**
     * Set ShouldCreateNewToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldCreateNewToken
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setShouldCreateNewToken($shouldCreateNewToken = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldCreateNewToken) && !is_bool($shouldCreateNewToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldCreateNewToken, true), gettype($shouldCreateNewToken)), __LINE__);
        }
        if (is_null($shouldCreateNewToken) || (is_array($shouldCreateNewToken) && empty($shouldCreateNewToken))) {
            unset($this->ShouldCreateNewToken);
        } else {
            $this->ShouldCreateNewToken = $shouldCreateNewToken;
        }
        return $this;
    }
    /**
     * Get ShouldIncludeCountTotalMatchingRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldIncludeCountTotalMatchingRows()
    {
        return isset($this->ShouldIncludeCountTotalMatchingRows) ? $this->ShouldIncludeCountTotalMatchingRows : null;
    }
    /**
     * Set ShouldIncludeCountTotalMatchingRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldIncludeCountTotalMatchingRows
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setShouldIncludeCountTotalMatchingRows($shouldIncludeCountTotalMatchingRows = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldIncludeCountTotalMatchingRows) && !is_bool($shouldIncludeCountTotalMatchingRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldIncludeCountTotalMatchingRows, true), gettype($shouldIncludeCountTotalMatchingRows)), __LINE__);
        }
        if (is_null($shouldIncludeCountTotalMatchingRows) || (is_array($shouldIncludeCountTotalMatchingRows) && empty($shouldIncludeCountTotalMatchingRows))) {
            unset($this->ShouldIncludeCountTotalMatchingRows);
        } else {
            $this->ShouldIncludeCountTotalMatchingRows = $shouldIncludeCountTotalMatchingRows;
        }
        return $this;
    }
    /**
     * Get SortingClause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSortingClause()
    {
        return isset($this->SortingClause) ? $this->SortingClause : null;
    }
    /**
     * Set SortingClause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sortingClause
     * @return \patest\StructType\ManipulateChunkedRetrieve_Request
     */
    public function setSortingClause($sortingClause = null)
    {
        // validation for constraint: string
        if (!is_null($sortingClause) && !is_string($sortingClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortingClause, true), gettype($sortingClause)), __LINE__);
        }
        if (is_null($sortingClause) || (is_array($sortingClause) && empty($sortingClause))) {
            unset($this->SortingClause);
        } else {
            $this->SortingClause = $sortingClause;
        }
        return $this;
    }
}
