<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadTicketsToAccessCard-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadTicketsToAccessCard-Request
 * @subpackage Structs
 */
class LoadTicketsToAccessCard_Request extends ExtensibleDataContract
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfLoadTicketsToAccessCardItem
     */
    public $Items;
    /**
     * The ResolveActiveAccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResolveActiveAccessCard;
    /**
     * Constructor method for LoadTicketsToAccessCard-Request
     * @uses LoadTicketsToAccessCard_Request::setItems()
     * @uses LoadTicketsToAccessCard_Request::setResolveActiveAccessCard()
     * @param \patest\ArrayType\ArrayOfLoadTicketsToAccessCardItem $items
     * @param bool $resolveActiveAccessCard
     */
    public function __construct(\patest\ArrayType\ArrayOfLoadTicketsToAccessCardItem $items = null, $resolveActiveAccessCard = null)
    {
        $this
            ->setItems($items)
            ->setResolveActiveAccessCard($resolveActiveAccessCard);
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfLoadTicketsToAccessCardItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfLoadTicketsToAccessCardItem $items
     * @return \patest\StructType\LoadTicketsToAccessCard_Request
     */
    public function setItems(\patest\ArrayType\ArrayOfLoadTicketsToAccessCardItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get ResolveActiveAccessCard value
     * @return bool|null
     */
    public function getResolveActiveAccessCard()
    {
        return $this->ResolveActiveAccessCard;
    }
    /**
     * Set ResolveActiveAccessCard value
     * @param bool $resolveActiveAccessCard
     * @return \patest\StructType\LoadTicketsToAccessCard_Request
     */
    public function setResolveActiveAccessCard($resolveActiveAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($resolveActiveAccessCard) && !is_bool($resolveActiveAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resolveActiveAccessCard, true), gettype($resolveActiveAccessCard)), __LINE__);
        }
        $this->ResolveActiveAccessCard = $resolveActiveAccessCard;
        return $this;
    }
}
