<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadTicketsToAccessCardItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadTicketsToAccessCardItem
 * @subpackage Structs
 */
class LoadTicketsToAccessCardItem extends AbstractStructBase
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketIds;
    /**
     * Constructor method for LoadTicketsToAccessCardItem
     * @uses LoadTicketsToAccessCardItem::setAccessCardId()
     * @uses LoadTicketsToAccessCardItem::setTicketIds()
     * @param string $accessCardId
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     */
    public function __construct($accessCardId = null, \patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setTicketIds($ticketIds);
    }
    /**
     * Get AccessCardId value
     * @return string|null
     */
    public function getAccessCardId()
    {
        return $this->AccessCardId;
    }
    /**
     * Set AccessCardId value
     * @param string $accessCardId
     * @return \patest\StructType\LoadTicketsToAccessCardItem
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        $this->AccessCardId = $accessCardId;
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     * @return \patest\StructType\LoadTicketsToAccessCardItem
     */
    public function setTicketIds(\patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
}
