<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadSingleTicketToAccessCardResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadSingleTicketToAccessCardResponse
 * @subpackage Structs
 */
class LoadSingleTicketToAccessCardResponse extends AbstractStructBase
{
    /**
     * The IsCardActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCardActive;
    /**
     * The IsSuccessfullyLoaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccessfullyLoaded;
    /**
     * The LoadError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoadError;
    /**
     * The ResolvedAccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResolvedAccessCardId;
    /**
     * The ResolvedAccessCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResolvedAccessCardNumber;
    /**
     * The SentToAccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SentToAccessCardId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for LoadSingleTicketToAccessCardResponse
     * @uses LoadSingleTicketToAccessCardResponse::setIsCardActive()
     * @uses LoadSingleTicketToAccessCardResponse::setIsSuccessfullyLoaded()
     * @uses LoadSingleTicketToAccessCardResponse::setLoadError()
     * @uses LoadSingleTicketToAccessCardResponse::setResolvedAccessCardId()
     * @uses LoadSingleTicketToAccessCardResponse::setResolvedAccessCardNumber()
     * @uses LoadSingleTicketToAccessCardResponse::setSentToAccessCardId()
     * @uses LoadSingleTicketToAccessCardResponse::setTicketId()
     * @param bool $isCardActive
     * @param bool $isSuccessfullyLoaded
     * @param string $loadError
     * @param string $resolvedAccessCardId
     * @param string $resolvedAccessCardNumber
     * @param string $sentToAccessCardId
     * @param string $ticketId
     */
    public function __construct($isCardActive = null, $isSuccessfullyLoaded = null, $loadError = null, $resolvedAccessCardId = null, $resolvedAccessCardNumber = null, $sentToAccessCardId = null, $ticketId = null)
    {
        $this
            ->setIsCardActive($isCardActive)
            ->setIsSuccessfullyLoaded($isSuccessfullyLoaded)
            ->setLoadError($loadError)
            ->setResolvedAccessCardId($resolvedAccessCardId)
            ->setResolvedAccessCardNumber($resolvedAccessCardNumber)
            ->setSentToAccessCardId($sentToAccessCardId)
            ->setTicketId($ticketId);
    }
    /**
     * Get IsCardActive value
     * @return bool|null
     */
    public function getIsCardActive()
    {
        return $this->IsCardActive;
    }
    /**
     * Set IsCardActive value
     * @param bool $isCardActive
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setIsCardActive($isCardActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCardActive) && !is_bool($isCardActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCardActive, true), gettype($isCardActive)), __LINE__);
        }
        $this->IsCardActive = $isCardActive;
        return $this;
    }
    /**
     * Get IsSuccessfullyLoaded value
     * @return bool|null
     */
    public function getIsSuccessfullyLoaded()
    {
        return $this->IsSuccessfullyLoaded;
    }
    /**
     * Set IsSuccessfullyLoaded value
     * @param bool $isSuccessfullyLoaded
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setIsSuccessfullyLoaded($isSuccessfullyLoaded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccessfullyLoaded) && !is_bool($isSuccessfullyLoaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSuccessfullyLoaded, true), gettype($isSuccessfullyLoaded)), __LINE__);
        }
        $this->IsSuccessfullyLoaded = $isSuccessfullyLoaded;
        return $this;
    }
    /**
     * Get LoadError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoadError()
    {
        return isset($this->LoadError) ? $this->LoadError : null;
    }
    /**
     * Set LoadError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loadError
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setLoadError($loadError = null)
    {
        // validation for constraint: string
        if (!is_null($loadError) && !is_string($loadError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadError, true), gettype($loadError)), __LINE__);
        }
        if (is_null($loadError) || (is_array($loadError) && empty($loadError))) {
            unset($this->LoadError);
        } else {
            $this->LoadError = $loadError;
        }
        return $this;
    }
    /**
     * Get ResolvedAccessCardId value
     * @return string|null
     */
    public function getResolvedAccessCardId()
    {
        return $this->ResolvedAccessCardId;
    }
    /**
     * Set ResolvedAccessCardId value
     * @param string $resolvedAccessCardId
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setResolvedAccessCardId($resolvedAccessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($resolvedAccessCardId) && !is_string($resolvedAccessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolvedAccessCardId, true), gettype($resolvedAccessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resolvedAccessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resolvedAccessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resolvedAccessCardId, true)), __LINE__);
        }
        $this->ResolvedAccessCardId = $resolvedAccessCardId;
        return $this;
    }
    /**
     * Get ResolvedAccessCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResolvedAccessCardNumber()
    {
        return isset($this->ResolvedAccessCardNumber) ? $this->ResolvedAccessCardNumber : null;
    }
    /**
     * Set ResolvedAccessCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resolvedAccessCardNumber
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setResolvedAccessCardNumber($resolvedAccessCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($resolvedAccessCardNumber) && !is_string($resolvedAccessCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolvedAccessCardNumber, true), gettype($resolvedAccessCardNumber)), __LINE__);
        }
        if (is_null($resolvedAccessCardNumber) || (is_array($resolvedAccessCardNumber) && empty($resolvedAccessCardNumber))) {
            unset($this->ResolvedAccessCardNumber);
        } else {
            $this->ResolvedAccessCardNumber = $resolvedAccessCardNumber;
        }
        return $this;
    }
    /**
     * Get SentToAccessCardId value
     * @return string|null
     */
    public function getSentToAccessCardId()
    {
        return $this->SentToAccessCardId;
    }
    /**
     * Set SentToAccessCardId value
     * @param string $sentToAccessCardId
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setSentToAccessCardId($sentToAccessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($sentToAccessCardId) && !is_string($sentToAccessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentToAccessCardId, true), gettype($sentToAccessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sentToAccessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sentToAccessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sentToAccessCardId, true)), __LINE__);
        }
        $this->SentToAccessCardId = $sentToAccessCardId;
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\LoadSingleTicketToAccessCardResponse
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
