<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadEventAccessControlManagerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadEventAccessControlManagerRequest
 * @subpackage Structs
 */
class LoadEventAccessControlManagerRequest extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ReloadIfAlreadyLoaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReloadIfAlreadyLoaded;
    /**
     * Constructor method for LoadEventAccessControlManagerRequest
     * @uses LoadEventAccessControlManagerRequest::setEventId()
     * @uses LoadEventAccessControlManagerRequest::setReloadIfAlreadyLoaded()
     * @param string $eventId
     * @param bool $reloadIfAlreadyLoaded
     */
    public function __construct($eventId = null, $reloadIfAlreadyLoaded = null)
    {
        $this
            ->setEventId($eventId)
            ->setReloadIfAlreadyLoaded($reloadIfAlreadyLoaded);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\LoadEventAccessControlManagerRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get ReloadIfAlreadyLoaded value
     * @return bool|null
     */
    public function getReloadIfAlreadyLoaded()
    {
        return $this->ReloadIfAlreadyLoaded;
    }
    /**
     * Set ReloadIfAlreadyLoaded value
     * @param bool $reloadIfAlreadyLoaded
     * @return \patest\StructType\LoadEventAccessControlManagerRequest
     */
    public function setReloadIfAlreadyLoaded($reloadIfAlreadyLoaded = null)
    {
        // validation for constraint: boolean
        if (!is_null($reloadIfAlreadyLoaded) && !is_bool($reloadIfAlreadyLoaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reloadIfAlreadyLoaded, true), gettype($reloadIfAlreadyLoaded)), __LINE__);
        }
        $this->ReloadIfAlreadyLoaded = $reloadIfAlreadyLoaded;
        return $this;
    }
}
