<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkedClient StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LinkedClient
 * @subpackage Structs
 */
class LinkedClient extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientImageUrl;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The IsFavourite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFavourite;
    /**
     * The IsStrong
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsStrong;
    /**
     * The IsTemporary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTemporary;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LeftRelationshipRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeftRelationshipRoleId;
    /**
     * The LoyaltyPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LoyaltyPoints;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The QualityPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $QualityPoints;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * The RelationshipTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeId;
    /**
     * The RightRelationshipRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RightRelationshipRoleId;
    /**
     * Constructor method for LinkedClient
     * @uses LinkedClient::setClientId()
     * @uses LinkedClient::setClientImageUrl()
     * @uses LinkedClient::setCrmId()
     * @uses LinkedClient::setFirstName()
     * @uses LinkedClient::setIsFavourite()
     * @uses LinkedClient::setIsStrong()
     * @uses LinkedClient::setIsTemporary()
     * @uses LinkedClient::setLastName()
     * @uses LinkedClient::setLeftRelationshipRoleId()
     * @uses LinkedClient::setLoyaltyPoints()
     * @uses LinkedClient::setName()
     * @uses LinkedClient::setQualityPoints()
     * @uses LinkedClient::setRelationshipId()
     * @uses LinkedClient::setRelationshipTypeId()
     * @uses LinkedClient::setRightRelationshipRoleId()
     * @param string $clientId
     * @param string $clientImageUrl
     * @param string $crmId
     * @param string $firstName
     * @param bool $isFavourite
     * @param bool $isStrong
     * @param bool $isTemporary
     * @param string $lastName
     * @param string $leftRelationshipRoleId
     * @param float $loyaltyPoints
     * @param string $name
     * @param float $qualityPoints
     * @param string $relationshipId
     * @param string $relationshipTypeId
     * @param string $rightRelationshipRoleId
     */
    public function __construct($clientId = null, $clientImageUrl = null, $crmId = null, $firstName = null, $isFavourite = null, $isStrong = null, $isTemporary = null, $lastName = null, $leftRelationshipRoleId = null, $loyaltyPoints = null, $name = null, $qualityPoints = null, $relationshipId = null, $relationshipTypeId = null, $rightRelationshipRoleId = null)
    {
        $this
            ->setClientId($clientId)
            ->setClientImageUrl($clientImageUrl)
            ->setCrmId($crmId)
            ->setFirstName($firstName)
            ->setIsFavourite($isFavourite)
            ->setIsStrong($isStrong)
            ->setIsTemporary($isTemporary)
            ->setLastName($lastName)
            ->setLeftRelationshipRoleId($leftRelationshipRoleId)
            ->setLoyaltyPoints($loyaltyPoints)
            ->setName($name)
            ->setQualityPoints($qualityPoints)
            ->setRelationshipId($relationshipId)
            ->setRelationshipTypeId($relationshipTypeId)
            ->setRightRelationshipRoleId($rightRelationshipRoleId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\LinkedClient
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientImageUrl()
    {
        return isset($this->ClientImageUrl) ? $this->ClientImageUrl : null;
    }
    /**
     * Set ClientImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientImageUrl
     * @return \patest\StructType\LinkedClient
     */
    public function setClientImageUrl($clientImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($clientImageUrl) && !is_string($clientImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientImageUrl, true), gettype($clientImageUrl)), __LINE__);
        }
        if (is_null($clientImageUrl) || (is_array($clientImageUrl) && empty($clientImageUrl))) {
            unset($this->ClientImageUrl);
        } else {
            $this->ClientImageUrl = $clientImageUrl;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\LinkedClient
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\LinkedClient
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get IsFavourite value
     * @return bool|null
     */
    public function getIsFavourite()
    {
        return $this->IsFavourite;
    }
    /**
     * Set IsFavourite value
     * @param bool $isFavourite
     * @return \patest\StructType\LinkedClient
     */
    public function setIsFavourite($isFavourite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFavourite) && !is_bool($isFavourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFavourite, true), gettype($isFavourite)), __LINE__);
        }
        $this->IsFavourite = $isFavourite;
        return $this;
    }
    /**
     * Get IsStrong value
     * @return bool|null
     */
    public function getIsStrong()
    {
        return $this->IsStrong;
    }
    /**
     * Set IsStrong value
     * @param bool $isStrong
     * @return \patest\StructType\LinkedClient
     */
    public function setIsStrong($isStrong = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStrong) && !is_bool($isStrong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStrong, true), gettype($isStrong)), __LINE__);
        }
        $this->IsStrong = $isStrong;
        return $this;
    }
    /**
     * Get IsTemporary value
     * @return bool|null
     */
    public function getIsTemporary()
    {
        return $this->IsTemporary;
    }
    /**
     * Set IsTemporary value
     * @param bool $isTemporary
     * @return \patest\StructType\LinkedClient
     */
    public function setIsTemporary($isTemporary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTemporary) && !is_bool($isTemporary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTemporary, true), gettype($isTemporary)), __LINE__);
        }
        $this->IsTemporary = $isTemporary;
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\LinkedClient
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LeftRelationshipRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftRelationshipRoleId()
    {
        return isset($this->LeftRelationshipRoleId) ? $this->LeftRelationshipRoleId : null;
    }
    /**
     * Set LeftRelationshipRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftRelationshipRoleId
     * @return \patest\StructType\LinkedClient
     */
    public function setLeftRelationshipRoleId($leftRelationshipRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($leftRelationshipRoleId) && !is_string($leftRelationshipRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftRelationshipRoleId, true), gettype($leftRelationshipRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leftRelationshipRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leftRelationshipRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leftRelationshipRoleId, true)), __LINE__);
        }
        if (is_null($leftRelationshipRoleId) || (is_array($leftRelationshipRoleId) && empty($leftRelationshipRoleId))) {
            unset($this->LeftRelationshipRoleId);
        } else {
            $this->LeftRelationshipRoleId = $leftRelationshipRoleId;
        }
        return $this;
    }
    /**
     * Get LoyaltyPoints value
     * @return float|null
     */
    public function getLoyaltyPoints()
    {
        return $this->LoyaltyPoints;
    }
    /**
     * Set LoyaltyPoints value
     * @param float $loyaltyPoints
     * @return \patest\StructType\LinkedClient
     */
    public function setLoyaltyPoints($loyaltyPoints = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyPoints) && !(is_float($loyaltyPoints) || is_numeric($loyaltyPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyPoints, true), gettype($loyaltyPoints)), __LINE__);
        }
        $this->LoyaltyPoints = $loyaltyPoints;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\LinkedClient
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get QualityPoints value
     * @return float|null
     */
    public function getQualityPoints()
    {
        return $this->QualityPoints;
    }
    /**
     * Set QualityPoints value
     * @param float $qualityPoints
     * @return \patest\StructType\LinkedClient
     */
    public function setQualityPoints($qualityPoints = null)
    {
        // validation for constraint: float
        if (!is_null($qualityPoints) && !(is_float($qualityPoints) || is_numeric($qualityPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qualityPoints, true), gettype($qualityPoints)), __LINE__);
        }
        $this->QualityPoints = $qualityPoints;
        return $this;
    }
    /**
     * Get RelationshipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipId()
    {
        return isset($this->RelationshipId) ? $this->RelationshipId : null;
    }
    /**
     * Set RelationshipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipId
     * @return \patest\StructType\LinkedClient
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        if (is_null($relationshipId) || (is_array($relationshipId) && empty($relationshipId))) {
            unset($this->RelationshipId);
        } else {
            $this->RelationshipId = $relationshipId;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeId()
    {
        return isset($this->RelationshipTypeId) ? $this->RelationshipTypeId : null;
    }
    /**
     * Set RelationshipTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeId
     * @return \patest\StructType\LinkedClient
     */
    public function setRelationshipTypeId($relationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeId) && !is_string($relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeId, true), gettype($relationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeId, true)), __LINE__);
        }
        if (is_null($relationshipTypeId) || (is_array($relationshipTypeId) && empty($relationshipTypeId))) {
            unset($this->RelationshipTypeId);
        } else {
            $this->RelationshipTypeId = $relationshipTypeId;
        }
        return $this;
    }
    /**
     * Get RightRelationshipRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRightRelationshipRoleId()
    {
        return isset($this->RightRelationshipRoleId) ? $this->RightRelationshipRoleId : null;
    }
    /**
     * Set RightRelationshipRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rightRelationshipRoleId
     * @return \patest\StructType\LinkedClient
     */
    public function setRightRelationshipRoleId($rightRelationshipRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($rightRelationshipRoleId) && !is_string($rightRelationshipRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightRelationshipRoleId, true), gettype($rightRelationshipRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rightRelationshipRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rightRelationshipRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rightRelationshipRoleId, true)), __LINE__);
        }
        if (is_null($rightRelationshipRoleId) || (is_array($rightRelationshipRoleId) && empty($rightRelationshipRoleId))) {
            unset($this->RightRelationshipRoleId);
        } else {
            $this->RightRelationshipRoleId = $rightRelationshipRoleId;
        }
        return $this;
    }
}
