<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LimitationConsumptionItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LimitationConsumptionItem
 * @subpackage Structs
 */
class LimitationConsumptionItem extends AbstractStructBase
{
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Available;
    /**
     * The CommittedReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommittedReserved;
    /**
     * The CommittedSold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommittedSold;
    /**
     * The Consumed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Consumed;
    /**
     * The DefinedAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinedAreaId;
    /**
     * The DefinedLimitValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DefinedLimitValue;
    /**
     * The DefinedLimitValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DefinedLimitValueType;
    /**
     * The DefinedPriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinedPriceLevelId;
    /**
     * The DefinedPriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $DefinedPriceTypeIds;
    /**
     * The EffectiveLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EffectiveLimit;
    /**
     * The LimitationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitationDescription;
    /**
     * The MatchingSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MatchingSeatCount;
    /**
     * The QuotaRemainder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuotaRemainder;
    /**
     * Constructor method for LimitationConsumptionItem
     * @uses LimitationConsumptionItem::setAvailable()
     * @uses LimitationConsumptionItem::setCommittedReserved()
     * @uses LimitationConsumptionItem::setCommittedSold()
     * @uses LimitationConsumptionItem::setConsumed()
     * @uses LimitationConsumptionItem::setDefinedAreaId()
     * @uses LimitationConsumptionItem::setDefinedLimitValue()
     * @uses LimitationConsumptionItem::setDefinedLimitValueType()
     * @uses LimitationConsumptionItem::setDefinedPriceLevelId()
     * @uses LimitationConsumptionItem::setDefinedPriceTypeIds()
     * @uses LimitationConsumptionItem::setEffectiveLimit()
     * @uses LimitationConsumptionItem::setLimitationDescription()
     * @uses LimitationConsumptionItem::setMatchingSeatCount()
     * @uses LimitationConsumptionItem::setQuotaRemainder()
     * @param int $available
     * @param int $committedReserved
     * @param int $committedSold
     * @param int $consumed
     * @param string $definedAreaId
     * @param int $definedLimitValue
     * @param string $definedLimitValueType
     * @param string $definedPriceLevelId
     * @param \patest\ArrayType\ArrayOfguid $definedPriceTypeIds
     * @param int $effectiveLimit
     * @param string $limitationDescription
     * @param int $matchingSeatCount
     * @param int $quotaRemainder
     */
    public function __construct($available = null, $committedReserved = null, $committedSold = null, $consumed = null, $definedAreaId = null, $definedLimitValue = null, $definedLimitValueType = null, $definedPriceLevelId = null, \patest\ArrayType\ArrayOfguid $definedPriceTypeIds = null, $effectiveLimit = null, $limitationDescription = null, $matchingSeatCount = null, $quotaRemainder = null)
    {
        $this
            ->setAvailable($available)
            ->setCommittedReserved($committedReserved)
            ->setCommittedSold($committedSold)
            ->setConsumed($consumed)
            ->setDefinedAreaId($definedAreaId)
            ->setDefinedLimitValue($definedLimitValue)
            ->setDefinedLimitValueType($definedLimitValueType)
            ->setDefinedPriceLevelId($definedPriceLevelId)
            ->setDefinedPriceTypeIds($definedPriceTypeIds)
            ->setEffectiveLimit($effectiveLimit)
            ->setLimitationDescription($limitationDescription)
            ->setMatchingSeatCount($matchingSeatCount)
            ->setQuotaRemainder($quotaRemainder);
    }
    /**
     * Get Available value
     * @return int|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param int $available
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: int
        if (!is_null($available) && !(is_int($available) || ctype_digit($available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get CommittedReserved value
     * @return int|null
     */
    public function getCommittedReserved()
    {
        return $this->CommittedReserved;
    }
    /**
     * Set CommittedReserved value
     * @param int $committedReserved
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setCommittedReserved($committedReserved = null)
    {
        // validation for constraint: int
        if (!is_null($committedReserved) && !(is_int($committedReserved) || ctype_digit($committedReserved))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($committedReserved, true), gettype($committedReserved)), __LINE__);
        }
        $this->CommittedReserved = $committedReserved;
        return $this;
    }
    /**
     * Get CommittedSold value
     * @return int|null
     */
    public function getCommittedSold()
    {
        return $this->CommittedSold;
    }
    /**
     * Set CommittedSold value
     * @param int $committedSold
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setCommittedSold($committedSold = null)
    {
        // validation for constraint: int
        if (!is_null($committedSold) && !(is_int($committedSold) || ctype_digit($committedSold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($committedSold, true), gettype($committedSold)), __LINE__);
        }
        $this->CommittedSold = $committedSold;
        return $this;
    }
    /**
     * Get Consumed value
     * @return int|null
     */
    public function getConsumed()
    {
        return $this->Consumed;
    }
    /**
     * Set Consumed value
     * @param int $consumed
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setConsumed($consumed = null)
    {
        // validation for constraint: int
        if (!is_null($consumed) && !(is_int($consumed) || ctype_digit($consumed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consumed, true), gettype($consumed)), __LINE__);
        }
        $this->Consumed = $consumed;
        return $this;
    }
    /**
     * Get DefinedAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinedAreaId()
    {
        return isset($this->DefinedAreaId) ? $this->DefinedAreaId : null;
    }
    /**
     * Set DefinedAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definedAreaId
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setDefinedAreaId($definedAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($definedAreaId) && !is_string($definedAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definedAreaId, true), gettype($definedAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definedAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definedAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definedAreaId, true)), __LINE__);
        }
        if (is_null($definedAreaId) || (is_array($definedAreaId) && empty($definedAreaId))) {
            unset($this->DefinedAreaId);
        } else {
            $this->DefinedAreaId = $definedAreaId;
        }
        return $this;
    }
    /**
     * Get DefinedLimitValue value
     * @return int|null
     */
    public function getDefinedLimitValue()
    {
        return $this->DefinedLimitValue;
    }
    /**
     * Set DefinedLimitValue value
     * @param int $definedLimitValue
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setDefinedLimitValue($definedLimitValue = null)
    {
        // validation for constraint: int
        if (!is_null($definedLimitValue) && !(is_int($definedLimitValue) || ctype_digit($definedLimitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($definedLimitValue, true), gettype($definedLimitValue)), __LINE__);
        }
        $this->DefinedLimitValue = $definedLimitValue;
        return $this;
    }
    /**
     * Get DefinedLimitValueType value
     * @return string|null
     */
    public function getDefinedLimitValueType()
    {
        return $this->DefinedLimitValueType;
    }
    /**
     * Set DefinedLimitValueType value
     * @uses \patest\EnumType\LimitationValueType::valueIsValid()
     * @uses \patest\EnumType\LimitationValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $definedLimitValueType
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setDefinedLimitValueType($definedLimitValueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationValueType::valueIsValid($definedLimitValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationValueType', is_array($definedLimitValueType) ? implode(', ', $definedLimitValueType) : var_export($definedLimitValueType, true), implode(', ', \patest\EnumType\LimitationValueType::getValidValues())), __LINE__);
        }
        $this->DefinedLimitValueType = $definedLimitValueType;
        return $this;
    }
    /**
     * Get DefinedPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinedPriceLevelId()
    {
        return isset($this->DefinedPriceLevelId) ? $this->DefinedPriceLevelId : null;
    }
    /**
     * Set DefinedPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definedPriceLevelId
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setDefinedPriceLevelId($definedPriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($definedPriceLevelId) && !is_string($definedPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definedPriceLevelId, true), gettype($definedPriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definedPriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definedPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definedPriceLevelId, true)), __LINE__);
        }
        if (is_null($definedPriceLevelId) || (is_array($definedPriceLevelId) && empty($definedPriceLevelId))) {
            unset($this->DefinedPriceLevelId);
        } else {
            $this->DefinedPriceLevelId = $definedPriceLevelId;
        }
        return $this;
    }
    /**
     * Get DefinedPriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getDefinedPriceTypeIds()
    {
        return isset($this->DefinedPriceTypeIds) ? $this->DefinedPriceTypeIds : null;
    }
    /**
     * Set DefinedPriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $definedPriceTypeIds
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setDefinedPriceTypeIds(\patest\ArrayType\ArrayOfguid $definedPriceTypeIds = null)
    {
        if (is_null($definedPriceTypeIds) || (is_array($definedPriceTypeIds) && empty($definedPriceTypeIds))) {
            unset($this->DefinedPriceTypeIds);
        } else {
            $this->DefinedPriceTypeIds = $definedPriceTypeIds;
        }
        return $this;
    }
    /**
     * Get EffectiveLimit value
     * @return int|null
     */
    public function getEffectiveLimit()
    {
        return $this->EffectiveLimit;
    }
    /**
     * Set EffectiveLimit value
     * @param int $effectiveLimit
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setEffectiveLimit($effectiveLimit = null)
    {
        // validation for constraint: int
        if (!is_null($effectiveLimit) && !(is_int($effectiveLimit) || ctype_digit($effectiveLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($effectiveLimit, true), gettype($effectiveLimit)), __LINE__);
        }
        $this->EffectiveLimit = $effectiveLimit;
        return $this;
    }
    /**
     * Get LimitationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitationDescription()
    {
        return isset($this->LimitationDescription) ? $this->LimitationDescription : null;
    }
    /**
     * Set LimitationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limitationDescription
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setLimitationDescription($limitationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($limitationDescription) && !is_string($limitationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitationDescription, true), gettype($limitationDescription)), __LINE__);
        }
        if (is_null($limitationDescription) || (is_array($limitationDescription) && empty($limitationDescription))) {
            unset($this->LimitationDescription);
        } else {
            $this->LimitationDescription = $limitationDescription;
        }
        return $this;
    }
    /**
     * Get MatchingSeatCount value
     * @return int|null
     */
    public function getMatchingSeatCount()
    {
        return $this->MatchingSeatCount;
    }
    /**
     * Set MatchingSeatCount value
     * @param int $matchingSeatCount
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setMatchingSeatCount($matchingSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($matchingSeatCount) && !(is_int($matchingSeatCount) || ctype_digit($matchingSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingSeatCount, true), gettype($matchingSeatCount)), __LINE__);
        }
        $this->MatchingSeatCount = $matchingSeatCount;
        return $this;
    }
    /**
     * Get QuotaRemainder value
     * @return int|null
     */
    public function getQuotaRemainder()
    {
        return $this->QuotaRemainder;
    }
    /**
     * Set QuotaRemainder value
     * @param int $quotaRemainder
     * @return \patest\StructType\LimitationConsumptionItem
     */
    public function setQuotaRemainder($quotaRemainder = null)
    {
        // validation for constraint: int
        if (!is_null($quotaRemainder) && !(is_int($quotaRemainder) || ctype_digit($quotaRemainder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotaRemainder, true), gettype($quotaRemainder)), __LINE__);
        }
        $this->QuotaRemainder = $quotaRemainder;
        return $this;
    }
}
