<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValueOfstringanyType StructType
 * @subpackage Structs
 */
class KeyValueOfstringanyType extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var mixed
     */
    public $Value;
    /**
     * Constructor method for KeyValueOfstringanyType
     * @uses KeyValueOfstringanyType::setKey()
     * @uses KeyValueOfstringanyType::setValue()
     * @param string $key
     * @param mixed $value
     */
    public function __construct($key = null, $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \patest\StructType\KeyValueOfstringanyType
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Value value
     * @return mixed|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param mixed $value
     * @return \patest\StructType\KeyValueOfstringanyType
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
