<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValueOfguidCrm.CombinedClientNameIqjNp0cc StructType
 * @subpackage Structs
 */
class KeyValueOfguidCrm_CombinedClientNameIqjNp0cc extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Key;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \patest\StructType\Crm_CombinedClientName
     */
    public $Value;
    /**
     * Constructor method for KeyValueOfguidCrm.CombinedClientNameIqjNp0cc
     * @uses KeyValueOfguidCrm_CombinedClientNameIqjNp0cc::setKey()
     * @uses KeyValueOfguidCrm_CombinedClientNameIqjNp0cc::setValue()
     * @param string $key
     * @param \patest\StructType\Crm_CombinedClientName $value
     */
    public function __construct($key = null, \patest\StructType\Crm_CombinedClientName $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \patest\StructType\KeyValueOfguidCrm_CombinedClientNameIqjNp0cc
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($key) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($key, true)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Value value
     * @return \patest\StructType\Crm_CombinedClientName|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \patest\StructType\Crm_CombinedClientName $value
     * @return \patest\StructType\KeyValueOfguidCrm_CombinedClientNameIqjNp0cc
     */
    public function setValue(\patest\StructType\Crm_CombinedClientName $value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
