<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValueOfguidArrayOfCustomSeatPricehpjoQDea StructType
 * @subpackage Structs
 */
class KeyValueOfguidArrayOfCustomSeatPricehpjoQDea extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Key;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCustomSeatPrice
     */
    public $Value;
    /**
     * Constructor method for KeyValueOfguidArrayOfCustomSeatPricehpjoQDea
     * @uses KeyValueOfguidArrayOfCustomSeatPricehpjoQDea::setKey()
     * @uses KeyValueOfguidArrayOfCustomSeatPricehpjoQDea::setValue()
     * @param string $key
     * @param \patest\ArrayType\ArrayOfCustomSeatPrice $value
     */
    public function __construct($key = null, \patest\ArrayType\ArrayOfCustomSeatPrice $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \patest\StructType\KeyValueOfguidArrayOfCustomSeatPricehpjoQDea
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($key) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($key, true)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Value value
     * @return \patest\ArrayType\ArrayOfCustomSeatPrice|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \patest\ArrayType\ArrayOfCustomSeatPrice $value
     * @return \patest\StructType\KeyValueOfguidArrayOfCustomSeatPricehpjoQDea
     */
    public function setValue(\patest\ArrayType\ArrayOfCustomSeatPrice $value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
