<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryPricingEntry StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InventoryPricingEntry
 * @subpackage Structs
 */
class InventoryPricingEntry extends AbstractStructBase
{
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInventoryPriceModifier
     */
    public $PriceModifiers;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The RegularPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RegularPrice;
    /**
     * The OriginalListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalListPrice;
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $BasePrice;
    /**
     * Constructor method for InventoryPricingEntry
     * @uses InventoryPricingEntry::setListPrice()
     * @uses InventoryPricingEntry::setPriceModifiers()
     * @uses InventoryPricingEntry::setTotalPrice()
     * @uses InventoryPricingEntry::setRegularPrice()
     * @uses InventoryPricingEntry::setOriginalListPrice()
     * @uses InventoryPricingEntry::setBasePrice()
     * @param \patest\StructType\Money $listPrice
     * @param \patest\ArrayType\ArrayOfInventoryPriceModifier $priceModifiers
     * @param \patest\StructType\Money $totalPrice
     * @param \patest\StructType\Money $regularPrice
     * @param \patest\StructType\Money $originalListPrice
     * @param \patest\StructType\Money $basePrice
     */
    public function __construct(\patest\StructType\Money $listPrice = null, \patest\ArrayType\ArrayOfInventoryPriceModifier $priceModifiers = null, \patest\StructType\Money $totalPrice = null, \patest\StructType\Money $regularPrice = null, \patest\StructType\Money $originalListPrice = null, \patest\StructType\Money $basePrice = null)
    {
        $this
            ->setListPrice($listPrice)
            ->setPriceModifiers($priceModifiers)
            ->setTotalPrice($totalPrice)
            ->setRegularPrice($regularPrice)
            ->setOriginalListPrice($originalListPrice)
            ->setBasePrice($basePrice);
    }
    /**
     * Get ListPrice value
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return $this->ListPrice;
    }
    /**
     * Set ListPrice value
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\InventoryPricingEntry
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        $this->ListPrice = $listPrice;
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInventoryPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInventoryPriceModifier $priceModifiers
     * @return \patest\StructType\InventoryPricingEntry
     */
    public function setPriceModifiers(\patest\ArrayType\ArrayOfInventoryPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\InventoryPricingEntry
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get RegularPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRegularPrice()
    {
        return isset($this->RegularPrice) ? $this->RegularPrice : null;
    }
    /**
     * Set RegularPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $regularPrice
     * @return \patest\StructType\InventoryPricingEntry
     */
    public function setRegularPrice(\patest\StructType\Money $regularPrice = null)
    {
        if (is_null($regularPrice) || (is_array($regularPrice) && empty($regularPrice))) {
            unset($this->RegularPrice);
        } else {
            $this->RegularPrice = $regularPrice;
        }
        return $this;
    }
    /**
     * Get OriginalListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalListPrice()
    {
        return isset($this->OriginalListPrice) ? $this->OriginalListPrice : null;
    }
    /**
     * Set OriginalListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalListPrice
     * @return \patest\StructType\InventoryPricingEntry
     */
    public function setOriginalListPrice(\patest\StructType\Money $originalListPrice = null)
    {
        if (is_null($originalListPrice) || (is_array($originalListPrice) && empty($originalListPrice))) {
            unset($this->OriginalListPrice);
        } else {
            $this->OriginalListPrice = $originalListPrice;
        }
        return $this;
    }
    /**
     * Get BasePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBasePrice()
    {
        return isset($this->BasePrice) ? $this->BasePrice : null;
    }
    /**
     * Set BasePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $basePrice
     * @return \patest\StructType\InventoryPricingEntry
     */
    public function setBasePrice(\patest\StructType\Money $basePrice = null)
    {
        if (is_null($basePrice) || (is_array($basePrice) && empty($basePrice))) {
            unset($this->BasePrice);
        } else {
            $this->BasePrice = $basePrice;
        }
        return $this;
    }
}
