<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryPriceModifier StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InventoryPriceModifier
 * @subpackage Structs
 */
class InventoryPriceModifier extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsIncludedInTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncludedInTotal;
    /**
     * Constructor method for InventoryPriceModifier
     * @uses InventoryPriceModifier::setAmount()
     * @uses InventoryPriceModifier::setId()
     * @uses InventoryPriceModifier::setIsIncludedInTotal()
     * @param \patest\StructType\Money $amount
     * @param string $id
     * @param bool $isIncludedInTotal
     */
    public function __construct(\patest\StructType\Money $amount = null, $id = null, $isIncludedInTotal = null)
    {
        $this
            ->setAmount($amount)
            ->setId($id)
            ->setIsIncludedInTotal($isIncludedInTotal);
    }
    /**
     * Get Amount value
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\InventoryPriceModifier
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\InventoryPriceModifier
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsIncludedInTotal value
     * @return bool|null
     */
    public function getIsIncludedInTotal()
    {
        return $this->IsIncludedInTotal;
    }
    /**
     * Set IsIncludedInTotal value
     * @param bool $isIncludedInTotal
     * @return \patest\StructType\InventoryPriceModifier
     */
    public function setIsIncludedInTotal($isIncludedInTotal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludedInTotal) && !is_bool($isIncludedInTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludedInTotal, true), gettype($isIncludedInTotal)), __LINE__);
        }
        $this->IsIncludedInTotal = $isIncludedInTotal;
        return $this;
    }
}
