<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidateEntityManagementQueryTokenRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InvalidateEntityManagementQueryTokenRequest
 * @subpackage Structs
 */
class InvalidateEntityManagementQueryTokenRequest extends AbstractStructBase
{
    /**
     * The QueryToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryToken;
    /**
     * Constructor method for InvalidateEntityManagementQueryTokenRequest
     * @uses InvalidateEntityManagementQueryTokenRequest::setQueryToken()
     * @param string $queryToken
     */
    public function __construct($queryToken = null)
    {
        $this
            ->setQueryToken($queryToken);
    }
    /**
     * Get QueryToken value
     * @return string|null
     */
    public function getQueryToken()
    {
        return $this->QueryToken;
    }
    /**
     * Set QueryToken value
     * @param string $queryToken
     * @return \patest\StructType\InvalidateEntityManagementQueryTokenRequest
     */
    public function setQueryToken($queryToken = null)
    {
        // validation for constraint: string
        if (!is_null($queryToken) && !is_string($queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryToken, true), gettype($queryToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryToken, true)), __LINE__);
        }
        $this->QueryToken = $queryToken;
        return $this;
    }
}
