<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidPropertyInCriteriaFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InvalidPropertyInCriteriaFault
 * @subpackage Structs
 */
class InvalidPropertyInCriteriaFault extends BasicFault
{
    /**
     * The CriteriaType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CriteriaType;
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * Constructor method for InvalidPropertyInCriteriaFault
     * @uses InvalidPropertyInCriteriaFault::setCriteriaType()
     * @uses InvalidPropertyInCriteriaFault::setPropertyName()
     * @param string $criteriaType
     * @param string $propertyName
     */
    public function __construct($criteriaType = null, $propertyName = null)
    {
        $this
            ->setCriteriaType($criteriaType)
            ->setPropertyName($propertyName);
    }
    /**
     * Get CriteriaType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriteriaType()
    {
        return isset($this->CriteriaType) ? $this->CriteriaType : null;
    }
    /**
     * Set CriteriaType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $criteriaType
     * @return \patest\StructType\InvalidPropertyInCriteriaFault
     */
    public function setCriteriaType($criteriaType = null)
    {
        // validation for constraint: string
        if (!is_null($criteriaType) && !is_string($criteriaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($criteriaType, true), gettype($criteriaType)), __LINE__);
        }
        if (is_null($criteriaType) || (is_array($criteriaType) && empty($criteriaType))) {
            unset($this->CriteriaType);
        } else {
            $this->CriteriaType = $criteriaType;
        }
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \patest\StructType\InvalidPropertyInCriteriaFault
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
}
