<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiateSubscriptionsRenewalRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiateSubscriptionsRenewalRequest
 * @subpackage Structs
 */
class InitiateSubscriptionsRenewalRequest extends ExtensibleDataContract
{
    /**
     * The RequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public $RequestDetails;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for InitiateSubscriptionsRenewalRequest
     * @uses InitiateSubscriptionsRenewalRequest::setRequestDetails()
     * @uses InitiateSubscriptionsRenewalRequest::setTransactionSnapshotType()
     * @param \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request $requestDetails
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request $requestDetails = null, $transactionSnapshotType = null)
    {
        $this
            ->setRequestDetails($requestDetails)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get RequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request|null
     */
    public function getRequestDetails()
    {
        return isset($this->RequestDetails) ? $this->RequestDetails : null;
    }
    /**
     * Set RequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request $requestDetails
     * @return \patest\StructType\InitiateSubscriptionsRenewalRequest
     */
    public function setRequestDetails(\patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request $requestDetails = null)
    {
        if (is_null($requestDetails) || (is_array($requestDetails) && empty($requestDetails))) {
            unset($this->RequestDetails);
        } else {
            $this->RequestDetails = $requestDetails;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\InitiateSubscriptionsRenewalRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
