<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiatePaymentSessionResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiatePaymentSessionResponse
 * @subpackage Structs
 */
class InitiatePaymentSessionResponse extends ExtensibleDataContract
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ClientAmount;
    /**
     * The ClientCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCurrencyCode;
    /**
     * The PaymentSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSessionId;
    /**
     * The PaymentSessionLocalRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentSessionLocalRefNumber;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * Constructor method for InitiatePaymentSessionResponse
     * @uses InitiatePaymentSessionResponse::setClientAmount()
     * @uses InitiatePaymentSessionResponse::setClientCurrencyCode()
     * @uses InitiatePaymentSessionResponse::setPaymentSessionId()
     * @uses InitiatePaymentSessionResponse::setPaymentSessionLocalRefNumber()
     * @uses InitiatePaymentSessionResponse::setTransactionSnapshot()
     * @param float $clientAmount
     * @param string $clientCurrencyCode
     * @param string $paymentSessionId
     * @param int $paymentSessionLocalRefNumber
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     */
    public function __construct($clientAmount = null, $clientCurrencyCode = null, $paymentSessionId = null, $paymentSessionLocalRefNumber = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setClientCurrencyCode($clientCurrencyCode)
            ->setPaymentSessionId($paymentSessionId)
            ->setPaymentSessionLocalRefNumber($paymentSessionLocalRefNumber)
            ->setTransactionSnapshot($transactionSnapshot);
    }
    /**
     * Get ClientAmount value
     * @return float|null
     */
    public function getClientAmount()
    {
        return $this->ClientAmount;
    }
    /**
     * Set ClientAmount value
     * @param float $clientAmount
     * @return \patest\StructType\InitiatePaymentSessionResponse
     */
    public function setClientAmount($clientAmount = null)
    {
        // validation for constraint: float
        if (!is_null($clientAmount) && !(is_float($clientAmount) || is_numeric($clientAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($clientAmount, true), gettype($clientAmount)), __LINE__);
        }
        $this->ClientAmount = $clientAmount;
        return $this;
    }
    /**
     * Get ClientCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCurrencyCode()
    {
        return isset($this->ClientCurrencyCode) ? $this->ClientCurrencyCode : null;
    }
    /**
     * Set ClientCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCurrencyCode
     * @return \patest\StructType\InitiatePaymentSessionResponse
     */
    public function setClientCurrencyCode($clientCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCurrencyCode) && !is_string($clientCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCurrencyCode, true), gettype($clientCurrencyCode)), __LINE__);
        }
        if (is_null($clientCurrencyCode) || (is_array($clientCurrencyCode) && empty($clientCurrencyCode))) {
            unset($this->ClientCurrencyCode);
        } else {
            $this->ClientCurrencyCode = $clientCurrencyCode;
        }
        return $this;
    }
    /**
     * Get PaymentSessionId value
     * @return string|null
     */
    public function getPaymentSessionId()
    {
        return $this->PaymentSessionId;
    }
    /**
     * Set PaymentSessionId value
     * @param string $paymentSessionId
     * @return \patest\StructType\InitiatePaymentSessionResponse
     */
    public function setPaymentSessionId($paymentSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionId) && !is_string($paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionId, true), gettype($paymentSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSessionId, true)), __LINE__);
        }
        $this->PaymentSessionId = $paymentSessionId;
        return $this;
    }
    /**
     * Get PaymentSessionLocalRefNumber value
     * @return int|null
     */
    public function getPaymentSessionLocalRefNumber()
    {
        return $this->PaymentSessionLocalRefNumber;
    }
    /**
     * Set PaymentSessionLocalRefNumber value
     * @param int $paymentSessionLocalRefNumber
     * @return \patest\StructType\InitiatePaymentSessionResponse
     */
    public function setPaymentSessionLocalRefNumber($paymentSessionLocalRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSessionLocalRefNumber) && !(is_int($paymentSessionLocalRefNumber) || ctype_digit($paymentSessionLocalRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentSessionLocalRefNumber, true), gettype($paymentSessionLocalRefNumber)), __LINE__);
        }
        $this->PaymentSessionLocalRefNumber = $paymentSessionLocalRefNumber;
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\InitiatePaymentSessionResponse
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
}
