<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiatePaymentDataCollectionSessionResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiatePaymentDataCollectionSessionResponse
 * @subpackage Structs
 */
class InitiatePaymentDataCollectionSessionResponse extends ExtensibleDataContract
{
    /**
     * The RequiredUserInteractionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\UserInteractionDetails
     */
    public $RequiredUserInteractionDetails;
    /**
     * The SessionCookie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionCookie;
    /**
     * Constructor method for InitiatePaymentDataCollectionSessionResponse
     * @uses InitiatePaymentDataCollectionSessionResponse::setRequiredUserInteractionDetails()
     * @uses InitiatePaymentDataCollectionSessionResponse::setSessionCookie()
     * @param \patest\StructType\UserInteractionDetails $requiredUserInteractionDetails
     * @param string $sessionCookie
     */
    public function __construct(\patest\StructType\UserInteractionDetails $requiredUserInteractionDetails = null, $sessionCookie = null)
    {
        $this
            ->setRequiredUserInteractionDetails($requiredUserInteractionDetails)
            ->setSessionCookie($sessionCookie);
    }
    /**
     * Get RequiredUserInteractionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\UserInteractionDetails|null
     */
    public function getRequiredUserInteractionDetails()
    {
        return isset($this->RequiredUserInteractionDetails) ? $this->RequiredUserInteractionDetails : null;
    }
    /**
     * Set RequiredUserInteractionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\UserInteractionDetails $requiredUserInteractionDetails
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionResponse
     */
    public function setRequiredUserInteractionDetails(\patest\StructType\UserInteractionDetails $requiredUserInteractionDetails = null)
    {
        if (is_null($requiredUserInteractionDetails) || (is_array($requiredUserInteractionDetails) && empty($requiredUserInteractionDetails))) {
            unset($this->RequiredUserInteractionDetails);
        } else {
            $this->RequiredUserInteractionDetails = $requiredUserInteractionDetails;
        }
        return $this;
    }
    /**
     * Get SessionCookie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionCookie()
    {
        return isset($this->SessionCookie) ? $this->SessionCookie : null;
    }
    /**
     * Set SessionCookie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionCookie
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionResponse
     */
    public function setSessionCookie($sessionCookie = null)
    {
        // validation for constraint: string
        if (!is_null($sessionCookie) && !is_string($sessionCookie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionCookie, true), gettype($sessionCookie)), __LINE__);
        }
        if (is_null($sessionCookie) || (is_array($sessionCookie) && empty($sessionCookie))) {
            unset($this->SessionCookie);
        } else {
            $this->SessionCookie = $sessionCookie;
        }
        return $this;
    }
}
