<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiatePaymentDataCollectionSessionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiatePaymentDataCollectionSessionRequest
 * @subpackage Structs
 */
class InitiatePaymentDataCollectionSessionRequest extends ExtensibleDataContract
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ClientParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ClientParameters;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The TransactionRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionRefNumber;
    /**
     * Constructor method for InitiatePaymentDataCollectionSessionRequest
     * @uses InitiatePaymentDataCollectionSessionRequest::setAmount()
     * @uses InitiatePaymentDataCollectionSessionRequest::setClientParameters()
     * @uses InitiatePaymentDataCollectionSessionRequest::setPaymentMethodId()
     * @uses InitiatePaymentDataCollectionSessionRequest::setPaymentTokenId()
     * @uses InitiatePaymentDataCollectionSessionRequest::setTransactionRefNumber()
     * @param \patest\StructType\Money $amount
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters
     * @param string $paymentMethodId
     * @param string $paymentTokenId
     * @param int $transactionRefNumber
     */
    public function __construct(\patest\StructType\Money $amount = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters = null, $paymentMethodId = null, $paymentTokenId = null, $transactionRefNumber = null)
    {
        $this
            ->setAmount($amount)
            ->setClientParameters($clientParameters)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setTransactionRefNumber($transactionRefNumber);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionRequest
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ClientParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getClientParameters()
    {
        return isset($this->ClientParameters) ? $this->ClientParameters : null;
    }
    /**
     * Set ClientParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionRequest
     */
    public function setClientParameters(\patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters = null)
    {
        if (is_null($clientParameters) || (is_array($clientParameters) && empty($clientParameters))) {
            unset($this->ClientParameters);
        } else {
            $this->ClientParameters = $clientParameters;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionRequest
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionRequest
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get TransactionRefNumber value
     * @return int|null
     */
    public function getTransactionRefNumber()
    {
        return $this->TransactionRefNumber;
    }
    /**
     * Set TransactionRefNumber value
     * @param int $transactionRefNumber
     * @return \patest\StructType\InitiatePaymentDataCollectionSessionRequest
     */
    public function setTransactionRefNumber($transactionRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionRefNumber) && !(is_int($transactionRefNumber) || ctype_digit($transactionRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionRefNumber, true), gettype($transactionRefNumber)), __LINE__);
        }
        $this->TransactionRefNumber = $transactionRefNumber;
        return $this;
    }
}
