<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.ServerRuntimeState StructType
 * @subpackage Structs
 */
class Infra_ServerRuntimeState extends AnyEntity
{
    /**
     * The AppServerVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppServerVersion;
    /**
     * The ClrVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClrVersion;
    /**
     * The CommandLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandLine;
    /**
     * The CpuUsage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CpuUsage;
    /**
     * The CurrentlyRunningRequestsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentlyRunningRequestsCount;
    /**
     * The IsClusteredMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClusteredMode;
    /**
     * The MemorySet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MemorySet;
    /**
     * The OsVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OsVersion;
    /**
     * The PeakMemorySet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PeakMemorySet;
    /**
     * The ProcessMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessMode;
    /**
     * The ProcessorsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessorsCount;
    /**
     * The ServerDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerDateTime;
    /**
     * The ServerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerName;
    /**
     * The StartupDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartupDateTime;
    /**
     * Constructor method for Infra.ServerRuntimeState
     * @uses Infra_ServerRuntimeState::setAppServerVersion()
     * @uses Infra_ServerRuntimeState::setClrVersion()
     * @uses Infra_ServerRuntimeState::setCommandLine()
     * @uses Infra_ServerRuntimeState::setCpuUsage()
     * @uses Infra_ServerRuntimeState::setCurrentlyRunningRequestsCount()
     * @uses Infra_ServerRuntimeState::setIsClusteredMode()
     * @uses Infra_ServerRuntimeState::setMemorySet()
     * @uses Infra_ServerRuntimeState::setOsVersion()
     * @uses Infra_ServerRuntimeState::setPeakMemorySet()
     * @uses Infra_ServerRuntimeState::setProcessMode()
     * @uses Infra_ServerRuntimeState::setProcessorsCount()
     * @uses Infra_ServerRuntimeState::setServerDateTime()
     * @uses Infra_ServerRuntimeState::setServerName()
     * @uses Infra_ServerRuntimeState::setStartupDateTime()
     * @param string $appServerVersion
     * @param string $clrVersion
     * @param string $commandLine
     * @param int $cpuUsage
     * @param int $currentlyRunningRequestsCount
     * @param bool $isClusteredMode
     * @param int $memorySet
     * @param string $osVersion
     * @param int $peakMemorySet
     * @param int $processMode
     * @param int $processorsCount
     * @param string $serverDateTime
     * @param string $serverName
     * @param string $startupDateTime
     */
    public function __construct($appServerVersion = null, $clrVersion = null, $commandLine = null, $cpuUsage = null, $currentlyRunningRequestsCount = null, $isClusteredMode = null, $memorySet = null, $osVersion = null, $peakMemorySet = null, $processMode = null, $processorsCount = null, $serverDateTime = null, $serverName = null, $startupDateTime = null)
    {
        $this
            ->setAppServerVersion($appServerVersion)
            ->setClrVersion($clrVersion)
            ->setCommandLine($commandLine)
            ->setCpuUsage($cpuUsage)
            ->setCurrentlyRunningRequestsCount($currentlyRunningRequestsCount)
            ->setIsClusteredMode($isClusteredMode)
            ->setMemorySet($memorySet)
            ->setOsVersion($osVersion)
            ->setPeakMemorySet($peakMemorySet)
            ->setProcessMode($processMode)
            ->setProcessorsCount($processorsCount)
            ->setServerDateTime($serverDateTime)
            ->setServerName($serverName)
            ->setStartupDateTime($startupDateTime);
    }
    /**
     * Get AppServerVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppServerVersion()
    {
        return isset($this->AppServerVersion) ? $this->AppServerVersion : null;
    }
    /**
     * Set AppServerVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appServerVersion
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setAppServerVersion($appServerVersion = null)
    {
        // validation for constraint: string
        if (!is_null($appServerVersion) && !is_string($appServerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appServerVersion, true), gettype($appServerVersion)), __LINE__);
        }
        if (is_null($appServerVersion) || (is_array($appServerVersion) && empty($appServerVersion))) {
            unset($this->AppServerVersion);
        } else {
            $this->AppServerVersion = $appServerVersion;
        }
        return $this;
    }
    /**
     * Get ClrVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClrVersion()
    {
        return isset($this->ClrVersion) ? $this->ClrVersion : null;
    }
    /**
     * Set ClrVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clrVersion
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setClrVersion($clrVersion = null)
    {
        // validation for constraint: string
        if (!is_null($clrVersion) && !is_string($clrVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clrVersion, true), gettype($clrVersion)), __LINE__);
        }
        if (is_null($clrVersion) || (is_array($clrVersion) && empty($clrVersion))) {
            unset($this->ClrVersion);
        } else {
            $this->ClrVersion = $clrVersion;
        }
        return $this;
    }
    /**
     * Get CommandLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandLine()
    {
        return isset($this->CommandLine) ? $this->CommandLine : null;
    }
    /**
     * Set CommandLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandLine
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setCommandLine($commandLine = null)
    {
        // validation for constraint: string
        if (!is_null($commandLine) && !is_string($commandLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandLine, true), gettype($commandLine)), __LINE__);
        }
        if (is_null($commandLine) || (is_array($commandLine) && empty($commandLine))) {
            unset($this->CommandLine);
        } else {
            $this->CommandLine = $commandLine;
        }
        return $this;
    }
    /**
     * Get CpuUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCpuUsage()
    {
        return isset($this->CpuUsage) ? $this->CpuUsage : null;
    }
    /**
     * Set CpuUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cpuUsage
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setCpuUsage($cpuUsage = null)
    {
        // validation for constraint: int
        if (!is_null($cpuUsage) && !(is_int($cpuUsage) || ctype_digit($cpuUsage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpuUsage, true), gettype($cpuUsage)), __LINE__);
        }
        if (is_null($cpuUsage) || (is_array($cpuUsage) && empty($cpuUsage))) {
            unset($this->CpuUsage);
        } else {
            $this->CpuUsage = $cpuUsage;
        }
        return $this;
    }
    /**
     * Get CurrentlyRunningRequestsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentlyRunningRequestsCount()
    {
        return isset($this->CurrentlyRunningRequestsCount) ? $this->CurrentlyRunningRequestsCount : null;
    }
    /**
     * Set CurrentlyRunningRequestsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentlyRunningRequestsCount
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setCurrentlyRunningRequestsCount($currentlyRunningRequestsCount = null)
    {
        // validation for constraint: int
        if (!is_null($currentlyRunningRequestsCount) && !(is_int($currentlyRunningRequestsCount) || ctype_digit($currentlyRunningRequestsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentlyRunningRequestsCount, true), gettype($currentlyRunningRequestsCount)), __LINE__);
        }
        if (is_null($currentlyRunningRequestsCount) || (is_array($currentlyRunningRequestsCount) && empty($currentlyRunningRequestsCount))) {
            unset($this->CurrentlyRunningRequestsCount);
        } else {
            $this->CurrentlyRunningRequestsCount = $currentlyRunningRequestsCount;
        }
        return $this;
    }
    /**
     * Get IsClusteredMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClusteredMode()
    {
        return isset($this->IsClusteredMode) ? $this->IsClusteredMode : null;
    }
    /**
     * Set IsClusteredMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClusteredMode
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setIsClusteredMode($isClusteredMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClusteredMode) && !is_bool($isClusteredMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClusteredMode, true), gettype($isClusteredMode)), __LINE__);
        }
        if (is_null($isClusteredMode) || (is_array($isClusteredMode) && empty($isClusteredMode))) {
            unset($this->IsClusteredMode);
        } else {
            $this->IsClusteredMode = $isClusteredMode;
        }
        return $this;
    }
    /**
     * Get MemorySet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMemorySet()
    {
        return isset($this->MemorySet) ? $this->MemorySet : null;
    }
    /**
     * Set MemorySet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $memorySet
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setMemorySet($memorySet = null)
    {
        // validation for constraint: int
        if (!is_null($memorySet) && !(is_int($memorySet) || ctype_digit($memorySet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memorySet, true), gettype($memorySet)), __LINE__);
        }
        if (is_null($memorySet) || (is_array($memorySet) && empty($memorySet))) {
            unset($this->MemorySet);
        } else {
            $this->MemorySet = $memorySet;
        }
        return $this;
    }
    /**
     * Get OsVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOsVersion()
    {
        return isset($this->OsVersion) ? $this->OsVersion : null;
    }
    /**
     * Set OsVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $osVersion
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setOsVersion($osVersion = null)
    {
        // validation for constraint: string
        if (!is_null($osVersion) && !is_string($osVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($osVersion, true), gettype($osVersion)), __LINE__);
        }
        if (is_null($osVersion) || (is_array($osVersion) && empty($osVersion))) {
            unset($this->OsVersion);
        } else {
            $this->OsVersion = $osVersion;
        }
        return $this;
    }
    /**
     * Get PeakMemorySet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPeakMemorySet()
    {
        return isset($this->PeakMemorySet) ? $this->PeakMemorySet : null;
    }
    /**
     * Set PeakMemorySet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $peakMemorySet
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setPeakMemorySet($peakMemorySet = null)
    {
        // validation for constraint: int
        if (!is_null($peakMemorySet) && !(is_int($peakMemorySet) || ctype_digit($peakMemorySet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($peakMemorySet, true), gettype($peakMemorySet)), __LINE__);
        }
        if (is_null($peakMemorySet) || (is_array($peakMemorySet) && empty($peakMemorySet))) {
            unset($this->PeakMemorySet);
        } else {
            $this->PeakMemorySet = $peakMemorySet;
        }
        return $this;
    }
    /**
     * Get ProcessMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessMode()
    {
        return isset($this->ProcessMode) ? $this->ProcessMode : null;
    }
    /**
     * Set ProcessMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processMode
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setProcessMode($processMode = null)
    {
        // validation for constraint: int
        if (!is_null($processMode) && !(is_int($processMode) || ctype_digit($processMode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processMode, true), gettype($processMode)), __LINE__);
        }
        if (is_null($processMode) || (is_array($processMode) && empty($processMode))) {
            unset($this->ProcessMode);
        } else {
            $this->ProcessMode = $processMode;
        }
        return $this;
    }
    /**
     * Get ProcessorsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessorsCount()
    {
        return isset($this->ProcessorsCount) ? $this->ProcessorsCount : null;
    }
    /**
     * Set ProcessorsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processorsCount
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setProcessorsCount($processorsCount = null)
    {
        // validation for constraint: int
        if (!is_null($processorsCount) && !(is_int($processorsCount) || ctype_digit($processorsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processorsCount, true), gettype($processorsCount)), __LINE__);
        }
        if (is_null($processorsCount) || (is_array($processorsCount) && empty($processorsCount))) {
            unset($this->ProcessorsCount);
        } else {
            $this->ProcessorsCount = $processorsCount;
        }
        return $this;
    }
    /**
     * Get ServerDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerDateTime()
    {
        return isset($this->ServerDateTime) ? $this->ServerDateTime : null;
    }
    /**
     * Set ServerDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serverDateTime
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setServerDateTime($serverDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($serverDateTime) && !is_string($serverDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverDateTime, true), gettype($serverDateTime)), __LINE__);
        }
        if (is_null($serverDateTime) || (is_array($serverDateTime) && empty($serverDateTime))) {
            unset($this->ServerDateTime);
        } else {
            $this->ServerDateTime = $serverDateTime;
        }
        return $this;
    }
    /**
     * Get ServerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerName()
    {
        return isset($this->ServerName) ? $this->ServerName : null;
    }
    /**
     * Set ServerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serverName
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setServerName($serverName = null)
    {
        // validation for constraint: string
        if (!is_null($serverName) && !is_string($serverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverName, true), gettype($serverName)), __LINE__);
        }
        if (is_null($serverName) || (is_array($serverName) && empty($serverName))) {
            unset($this->ServerName);
        } else {
            $this->ServerName = $serverName;
        }
        return $this;
    }
    /**
     * Get StartupDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartupDateTime()
    {
        return isset($this->StartupDateTime) ? $this->StartupDateTime : null;
    }
    /**
     * Set StartupDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startupDateTime
     * @return \patest\StructType\Infra_ServerRuntimeState
     */
    public function setStartupDateTime($startupDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startupDateTime) && !is_string($startupDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startupDateTime, true), gettype($startupDateTime)), __LINE__);
        }
        if (is_null($startupDateTime) || (is_array($startupDateTime) && empty($startupDateTime))) {
            unset($this->StartupDateTime);
        } else {
            $this->StartupDateTime = $startupDateTime;
        }
        return $this;
    }
}
