<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.ScriptLog StructType
 * @subpackage Structs
 */
class Infra_ScriptLog extends AnyEntity
{
    /**
     * The GUID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GUID;
    /**
     * The LocalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalID;
    /**
     * The Path
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Path;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Project;
    /**
     * The RowId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowId;
    /**
     * The SourceDB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceDB;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Version;
    /**
     * The VersionLogID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VersionLogID;
    /**
     * Constructor method for Infra.ScriptLog
     * @uses Infra_ScriptLog::setGUID()
     * @uses Infra_ScriptLog::setLocalID()
     * @uses Infra_ScriptLog::setPath()
     * @uses Infra_ScriptLog::setProject()
     * @uses Infra_ScriptLog::setRowId()
     * @uses Infra_ScriptLog::setSourceDB()
     * @uses Infra_ScriptLog::setVersion()
     * @uses Infra_ScriptLog::setVersionLogID()
     * @param string $gUID
     * @param int $localID
     * @param string $path
     * @param string $project
     * @param int $rowId
     * @param string $sourceDB
     * @param int $version
     * @param int $versionLogID
     */
    public function __construct($gUID = null, $localID = null, $path = null, $project = null, $rowId = null, $sourceDB = null, $version = null, $versionLogID = null)
    {
        $this
            ->setGUID($gUID)
            ->setLocalID($localID)
            ->setPath($path)
            ->setProject($project)
            ->setRowId($rowId)
            ->setSourceDB($sourceDB)
            ->setVersion($version)
            ->setVersionLogID($versionLogID);
    }
    /**
     * Get GUID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGUID()
    {
        return isset($this->GUID) ? $this->GUID : null;
    }
    /**
     * Set GUID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gUID
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setGUID($gUID = null)
    {
        // validation for constraint: string
        if (!is_null($gUID) && !is_string($gUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUID, true), gettype($gUID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gUID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gUID, true)), __LINE__);
        }
        if (is_null($gUID) || (is_array($gUID) && empty($gUID))) {
            unset($this->GUID);
        } else {
            $this->GUID = $gUID;
        }
        return $this;
    }
    /**
     * Get LocalID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalID()
    {
        return isset($this->LocalID) ? $this->LocalID : null;
    }
    /**
     * Set LocalID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localID
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setLocalID($localID = null)
    {
        // validation for constraint: int
        if (!is_null($localID) && !(is_int($localID) || ctype_digit($localID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localID, true), gettype($localID)), __LINE__);
        }
        if (is_null($localID) || (is_array($localID) && empty($localID))) {
            unset($this->LocalID);
        } else {
            $this->LocalID = $localID;
        }
        return $this;
    }
    /**
     * Get Path value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPath()
    {
        return isset($this->Path) ? $this->Path : null;
    }
    /**
     * Set Path value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $path
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($path, true), gettype($path)), __LINE__);
        }
        if (is_null($path) || (is_array($path) && empty($path))) {
            unset($this->Path);
        } else {
            $this->Path = $path;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $project
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setProject($project = null)
    {
        // validation for constraint: string
        if (!is_null($project) && !is_string($project)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project, true), gettype($project)), __LINE__);
        }
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get RowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowId()
    {
        return isset($this->RowId) ? $this->RowId : null;
    }
    /**
     * Set RowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowId
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setRowId($rowId = null)
    {
        // validation for constraint: int
        if (!is_null($rowId) && !(is_int($rowId) || ctype_digit($rowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowId, true), gettype($rowId)), __LINE__);
        }
        if (is_null($rowId) || (is_array($rowId) && empty($rowId))) {
            unset($this->RowId);
        } else {
            $this->RowId = $rowId;
        }
        return $this;
    }
    /**
     * Get SourceDB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceDB()
    {
        return isset($this->SourceDB) ? $this->SourceDB : null;
    }
    /**
     * Set SourceDB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceDB
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setSourceDB($sourceDB = null)
    {
        // validation for constraint: string
        if (!is_null($sourceDB) && !is_string($sourceDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceDB, true), gettype($sourceDB)), __LINE__);
        }
        if (is_null($sourceDB) || (is_array($sourceDB) && empty($sourceDB))) {
            unset($this->SourceDB);
        } else {
            $this->SourceDB = $sourceDB;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $version
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
    /**
     * Get VersionLogID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVersionLogID()
    {
        return isset($this->VersionLogID) ? $this->VersionLogID : null;
    }
    /**
     * Set VersionLogID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $versionLogID
     * @return \patest\StructType\Infra_ScriptLog
     */
    public function setVersionLogID($versionLogID = null)
    {
        // validation for constraint: int
        if (!is_null($versionLogID) && !(is_int($versionLogID) || ctype_digit($versionLogID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versionLogID, true), gettype($versionLogID)), __LINE__);
        }
        if (is_null($versionLogID) || (is_array($versionLogID) && empty($versionLogID))) {
            unset($this->VersionLogID);
        } else {
            $this->VersionLogID = $versionLogID;
        }
        return $this;
    }
}
