<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.InstallationLogEntityFilter StructType
 * @subpackage Structs
 */
class Infra_InstallationLogEntityFilter extends FilterEntity
{
    /**
     * The InstallationDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallationDateFrom;
    /**
     * The InstallationDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallationDateTo;
    /**
     * The LogType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogType;
    /**
     * The SourceDBEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SourceDBEnum;
    /**
     * Constructor method for Infra.InstallationLogEntityFilter
     * @uses Infra_InstallationLogEntityFilter::setInstallationDateFrom()
     * @uses Infra_InstallationLogEntityFilter::setInstallationDateTo()
     * @uses Infra_InstallationLogEntityFilter::setLogType()
     * @uses Infra_InstallationLogEntityFilter::setSourceDBEnum()
     * @param string $installationDateFrom
     * @param string $installationDateTo
     * @param string $logType
     * @param int $sourceDBEnum
     */
    public function __construct($installationDateFrom = null, $installationDateTo = null, $logType = null, $sourceDBEnum = null)
    {
        $this
            ->setInstallationDateFrom($installationDateFrom)
            ->setInstallationDateTo($installationDateTo)
            ->setLogType($logType)
            ->setSourceDBEnum($sourceDBEnum);
    }
    /**
     * Get InstallationDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallationDateFrom()
    {
        return isset($this->InstallationDateFrom) ? $this->InstallationDateFrom : null;
    }
    /**
     * Set InstallationDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installationDateFrom
     * @return \patest\StructType\Infra_InstallationLogEntityFilter
     */
    public function setInstallationDateFrom($installationDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($installationDateFrom) && !is_string($installationDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installationDateFrom, true), gettype($installationDateFrom)), __LINE__);
        }
        if (is_null($installationDateFrom) || (is_array($installationDateFrom) && empty($installationDateFrom))) {
            unset($this->InstallationDateFrom);
        } else {
            $this->InstallationDateFrom = $installationDateFrom;
        }
        return $this;
    }
    /**
     * Get InstallationDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallationDateTo()
    {
        return isset($this->InstallationDateTo) ? $this->InstallationDateTo : null;
    }
    /**
     * Set InstallationDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installationDateTo
     * @return \patest\StructType\Infra_InstallationLogEntityFilter
     */
    public function setInstallationDateTo($installationDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($installationDateTo) && !is_string($installationDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installationDateTo, true), gettype($installationDateTo)), __LINE__);
        }
        if (is_null($installationDateTo) || (is_array($installationDateTo) && empty($installationDateTo))) {
            unset($this->InstallationDateTo);
        } else {
            $this->InstallationDateTo = $installationDateTo;
        }
        return $this;
    }
    /**
     * Get LogType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogType()
    {
        return isset($this->LogType) ? $this->LogType : null;
    }
    /**
     * Set LogType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logType
     * @return \patest\StructType\Infra_InstallationLogEntityFilter
     */
    public function setLogType($logType = null)
    {
        // validation for constraint: string
        if (!is_null($logType) && !is_string($logType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logType, true), gettype($logType)), __LINE__);
        }
        if (is_null($logType) || (is_array($logType) && empty($logType))) {
            unset($this->LogType);
        } else {
            $this->LogType = $logType;
        }
        return $this;
    }
    /**
     * Get SourceDBEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSourceDBEnum()
    {
        return isset($this->SourceDBEnum) ? $this->SourceDBEnum : null;
    }
    /**
     * Set SourceDBEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sourceDBEnum
     * @return \patest\StructType\Infra_InstallationLogEntityFilter
     */
    public function setSourceDBEnum($sourceDBEnum = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDBEnum) && !(is_int($sourceDBEnum) || ctype_digit($sourceDBEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDBEnum, true), gettype($sourceDBEnum)), __LINE__);
        }
        if (is_null($sourceDBEnum) || (is_array($sourceDBEnum) && empty($sourceDBEnum))) {
            unset($this->SourceDBEnum);
        } else {
            $this->SourceDBEnum = $sourceDBEnum;
        }
        return $this;
    }
}
