<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.GlobalCounterType StructType
 * @subpackage Structs
 */
class Infra_GlobalCounterType extends PersistableEntity
{
    /**
     * The AllowsCounterChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowsCounterChange;
    /**
     * The AllowsMultipleCounters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowsMultipleCounters;
    /**
     * The CanBeCreatedByUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanBeCreatedByUser;
    /**
     * The DefaultCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCategory;
    /**
     * The DefaultService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultService;
    /**
     * The DefaultSubCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultSubCategory;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NameCaptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameCaptionId;
    /**
     * The RelevantFor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelevantFor;
    /**
     * Constructor method for Infra.GlobalCounterType
     * @uses Infra_GlobalCounterType::setAllowsCounterChange()
     * @uses Infra_GlobalCounterType::setAllowsMultipleCounters()
     * @uses Infra_GlobalCounterType::setCanBeCreatedByUser()
     * @uses Infra_GlobalCounterType::setDefaultCategory()
     * @uses Infra_GlobalCounterType::setDefaultService()
     * @uses Infra_GlobalCounterType::setDefaultSubCategory()
     * @uses Infra_GlobalCounterType::setName()
     * @uses Infra_GlobalCounterType::setNameCaptionId()
     * @uses Infra_GlobalCounterType::setRelevantFor()
     * @param bool $allowsCounterChange
     * @param bool $allowsMultipleCounters
     * @param bool $canBeCreatedByUser
     * @param string $defaultCategory
     * @param string $defaultService
     * @param string $defaultSubCategory
     * @param \patest\StructType\GlobalString $name
     * @param string $nameCaptionId
     * @param string $relevantFor
     */
    public function __construct($allowsCounterChange = null, $allowsMultipleCounters = null, $canBeCreatedByUser = null, $defaultCategory = null, $defaultService = null, $defaultSubCategory = null, \patest\StructType\GlobalString $name = null, $nameCaptionId = null, $relevantFor = null)
    {
        $this
            ->setAllowsCounterChange($allowsCounterChange)
            ->setAllowsMultipleCounters($allowsMultipleCounters)
            ->setCanBeCreatedByUser($canBeCreatedByUser)
            ->setDefaultCategory($defaultCategory)
            ->setDefaultService($defaultService)
            ->setDefaultSubCategory($defaultSubCategory)
            ->setName($name)
            ->setNameCaptionId($nameCaptionId)
            ->setRelevantFor($relevantFor);
    }
    /**
     * Get AllowsCounterChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowsCounterChange()
    {
        return isset($this->AllowsCounterChange) ? $this->AllowsCounterChange : null;
    }
    /**
     * Set AllowsCounterChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowsCounterChange
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setAllowsCounterChange($allowsCounterChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowsCounterChange) && !is_bool($allowsCounterChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowsCounterChange, true), gettype($allowsCounterChange)), __LINE__);
        }
        if (is_null($allowsCounterChange) || (is_array($allowsCounterChange) && empty($allowsCounterChange))) {
            unset($this->AllowsCounterChange);
        } else {
            $this->AllowsCounterChange = $allowsCounterChange;
        }
        return $this;
    }
    /**
     * Get AllowsMultipleCounters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowsMultipleCounters()
    {
        return isset($this->AllowsMultipleCounters) ? $this->AllowsMultipleCounters : null;
    }
    /**
     * Set AllowsMultipleCounters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowsMultipleCounters
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setAllowsMultipleCounters($allowsMultipleCounters = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowsMultipleCounters) && !is_bool($allowsMultipleCounters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowsMultipleCounters, true), gettype($allowsMultipleCounters)), __LINE__);
        }
        if (is_null($allowsMultipleCounters) || (is_array($allowsMultipleCounters) && empty($allowsMultipleCounters))) {
            unset($this->AllowsMultipleCounters);
        } else {
            $this->AllowsMultipleCounters = $allowsMultipleCounters;
        }
        return $this;
    }
    /**
     * Get CanBeCreatedByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanBeCreatedByUser()
    {
        return isset($this->CanBeCreatedByUser) ? $this->CanBeCreatedByUser : null;
    }
    /**
     * Set CanBeCreatedByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canBeCreatedByUser
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setCanBeCreatedByUser($canBeCreatedByUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeCreatedByUser) && !is_bool($canBeCreatedByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeCreatedByUser, true), gettype($canBeCreatedByUser)), __LINE__);
        }
        if (is_null($canBeCreatedByUser) || (is_array($canBeCreatedByUser) && empty($canBeCreatedByUser))) {
            unset($this->CanBeCreatedByUser);
        } else {
            $this->CanBeCreatedByUser = $canBeCreatedByUser;
        }
        return $this;
    }
    /**
     * Get DefaultCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCategory()
    {
        return isset($this->DefaultCategory) ? $this->DefaultCategory : null;
    }
    /**
     * Set DefaultCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCategory
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setDefaultCategory($defaultCategory = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCategory) && !is_string($defaultCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCategory, true), gettype($defaultCategory)), __LINE__);
        }
        if (is_null($defaultCategory) || (is_array($defaultCategory) && empty($defaultCategory))) {
            unset($this->DefaultCategory);
        } else {
            $this->DefaultCategory = $defaultCategory;
        }
        return $this;
    }
    /**
     * Get DefaultService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultService()
    {
        return isset($this->DefaultService) ? $this->DefaultService : null;
    }
    /**
     * Set DefaultService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultService
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setDefaultService($defaultService = null)
    {
        // validation for constraint: string
        if (!is_null($defaultService) && !is_string($defaultService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultService, true), gettype($defaultService)), __LINE__);
        }
        if (is_null($defaultService) || (is_array($defaultService) && empty($defaultService))) {
            unset($this->DefaultService);
        } else {
            $this->DefaultService = $defaultService;
        }
        return $this;
    }
    /**
     * Get DefaultSubCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSubCategory()
    {
        return isset($this->DefaultSubCategory) ? $this->DefaultSubCategory : null;
    }
    /**
     * Set DefaultSubCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSubCategory
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setDefaultSubCategory($defaultSubCategory = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSubCategory) && !is_string($defaultSubCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSubCategory, true), gettype($defaultSubCategory)), __LINE__);
        }
        if (is_null($defaultSubCategory) || (is_array($defaultSubCategory) && empty($defaultSubCategory))) {
            unset($this->DefaultSubCategory);
        } else {
            $this->DefaultSubCategory = $defaultSubCategory;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameCaptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameCaptionId()
    {
        return isset($this->NameCaptionId) ? $this->NameCaptionId : null;
    }
    /**
     * Set NameCaptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameCaptionId
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setNameCaptionId($nameCaptionId = null)
    {
        // validation for constraint: string
        if (!is_null($nameCaptionId) && !is_string($nameCaptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameCaptionId, true), gettype($nameCaptionId)), __LINE__);
        }
        if (is_null($nameCaptionId) || (is_array($nameCaptionId) && empty($nameCaptionId))) {
            unset($this->NameCaptionId);
        } else {
            $this->NameCaptionId = $nameCaptionId;
        }
        return $this;
    }
    /**
     * Get RelevantFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelevantFor()
    {
        return isset($this->RelevantFor) ? $this->RelevantFor : null;
    }
    /**
     * Set RelevantFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relevantFor
     * @return \patest\StructType\Infra_GlobalCounterType
     */
    public function setRelevantFor($relevantFor = null)
    {
        // validation for constraint: string
        if (!is_null($relevantFor) && !is_string($relevantFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relevantFor, true), gettype($relevantFor)), __LINE__);
        }
        if (is_null($relevantFor) || (is_array($relevantFor) && empty($relevantFor))) {
            unset($this->RelevantFor);
        } else {
            $this->RelevantFor = $relevantFor;
        }
        return $this;
    }
}
