<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.DbHitLog StructType
 * @subpackage Structs
 */
class Infra_DbHitLog extends PersistableEntity
{
    /**
     * The CorrelationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CorrelationId;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The HitCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HitCategory;
    /**
     * The HitDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HitDescription;
    /**
     * The Resources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Resources;
    /**
     * The StartDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTimeUtc;
    /**
     * The TraceXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TraceXml;
    /**
     * Constructor method for Infra.DbHitLog
     * @uses Infra_DbHitLog::setCorrelationId()
     * @uses Infra_DbHitLog::setDuration()
     * @uses Infra_DbHitLog::setHitCategory()
     * @uses Infra_DbHitLog::setHitDescription()
     * @uses Infra_DbHitLog::setResources()
     * @uses Infra_DbHitLog::setStartDateTimeUtc()
     * @uses Infra_DbHitLog::setTraceXml()
     * @param string $correlationId
     * @param int $duration
     * @param string $hitCategory
     * @param string $hitDescription
     * @param string $resources
     * @param string $startDateTimeUtc
     * @param string $traceXml
     */
    public function __construct($correlationId = null, $duration = null, $hitCategory = null, $hitDescription = null, $resources = null, $startDateTimeUtc = null, $traceXml = null)
    {
        $this
            ->setCorrelationId($correlationId)
            ->setDuration($duration)
            ->setHitCategory($hitCategory)
            ->setHitDescription($hitDescription)
            ->setResources($resources)
            ->setStartDateTimeUtc($startDateTimeUtc)
            ->setTraceXml($traceXml);
    }
    /**
     * Get CorrelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorrelationId()
    {
        return isset($this->CorrelationId) ? $this->CorrelationId : null;
    }
    /**
     * Set CorrelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $correlationId
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setCorrelationId($correlationId = null)
    {
        // validation for constraint: string
        if (!is_null($correlationId) && !is_string($correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationId, true), gettype($correlationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($correlationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($correlationId, true)), __LINE__);
        }
        if (is_null($correlationId) || (is_array($correlationId) && empty($correlationId))) {
            unset($this->CorrelationId);
        } else {
            $this->CorrelationId = $correlationId;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get HitCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHitCategory()
    {
        return isset($this->HitCategory) ? $this->HitCategory : null;
    }
    /**
     * Set HitCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hitCategory
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setHitCategory($hitCategory = null)
    {
        // validation for constraint: string
        if (!is_null($hitCategory) && !is_string($hitCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitCategory, true), gettype($hitCategory)), __LINE__);
        }
        if (is_null($hitCategory) || (is_array($hitCategory) && empty($hitCategory))) {
            unset($this->HitCategory);
        } else {
            $this->HitCategory = $hitCategory;
        }
        return $this;
    }
    /**
     * Get HitDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHitDescription()
    {
        return isset($this->HitDescription) ? $this->HitDescription : null;
    }
    /**
     * Set HitDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hitDescription
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setHitDescription($hitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($hitDescription) && !is_string($hitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitDescription, true), gettype($hitDescription)), __LINE__);
        }
        if (is_null($hitDescription) || (is_array($hitDescription) && empty($hitDescription))) {
            unset($this->HitDescription);
        } else {
            $this->HitDescription = $hitDescription;
        }
        return $this;
    }
    /**
     * Get Resources value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResources()
    {
        return isset($this->Resources) ? $this->Resources : null;
    }
    /**
     * Set Resources value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resources
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setResources($resources = null)
    {
        // validation for constraint: string
        if (!is_null($resources) && !is_string($resources)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resources, true), gettype($resources)), __LINE__);
        }
        if (is_null($resources) || (is_array($resources) && empty($resources))) {
            unset($this->Resources);
        } else {
            $this->Resources = $resources;
        }
        return $this;
    }
    /**
     * Get StartDateTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTimeUtc()
    {
        return isset($this->StartDateTimeUtc) ? $this->StartDateTimeUtc : null;
    }
    /**
     * Set StartDateTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTimeUtc
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setStartDateTimeUtc($startDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTimeUtc) && !is_string($startDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTimeUtc, true), gettype($startDateTimeUtc)), __LINE__);
        }
        if (is_null($startDateTimeUtc) || (is_array($startDateTimeUtc) && empty($startDateTimeUtc))) {
            unset($this->StartDateTimeUtc);
        } else {
            $this->StartDateTimeUtc = $startDateTimeUtc;
        }
        return $this;
    }
    /**
     * Get TraceXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraceXml()
    {
        return isset($this->TraceXml) ? $this->TraceXml : null;
    }
    /**
     * Set TraceXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traceXml
     * @return \patest\StructType\Infra_DbHitLog
     */
    public function setTraceXml($traceXml = null)
    {
        // validation for constraint: string
        if (!is_null($traceXml) && !is_string($traceXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceXml, true), gettype($traceXml)), __LINE__);
        }
        if (is_null($traceXml) || (is_array($traceXml) && empty($traceXml))) {
            unset($this->TraceXml);
        } else {
            $this->TraceXml = $traceXml;
        }
        return $this;
    }
}
