<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.RequestType StructType
 * @subpackage Structs
 */
class HelpDesk_RequestType extends PersistableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AdministratorScreenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdministratorScreenName;
    /**
     * The DefaultAssignTo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAssignTo;
    /**
     * The DefaultAssignToDisplayString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultAssignToDisplayString;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DisplayOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayOnline;
    /**
     * The EndClientScreenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndClientScreenName;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsCustomerRelated
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCustomerRelated;
    /**
     * The IsProductRelated
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProductRelated;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HelpDesk_Media
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition
     */
    public $Notifications;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Reminders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_ReminderDefinition
     */
    public $Reminders;
    /**
     * The RequestCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestCategory;
    /**
     * The Security
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_SecurityDefinitionsForRequestType
     */
    public $Security;
    /**
     * The SellerScreenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellerScreenName;
    /**
     * The Statuses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage
     */
    public $Statuses;
    /**
     * The UnifyScreenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnifyScreenName;
    /**
     * The UsersMayAddRequestsManually
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsersMayAddRequestsManually;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for HelpDesk.RequestType
     * @uses HelpDesk_RequestType::setAclSchemeId()
     * @uses HelpDesk_RequestType::setAdministratorScreenName()
     * @uses HelpDesk_RequestType::setDefaultAssignTo()
     * @uses HelpDesk_RequestType::setDefaultAssignToDisplayString()
     * @uses HelpDesk_RequestType::setDescription()
     * @uses HelpDesk_RequestType::setDisplayOnline()
     * @uses HelpDesk_RequestType::setEndClientScreenName()
     * @uses HelpDesk_RequestType::setEntityName()
     * @uses HelpDesk_RequestType::setIsActive()
     * @uses HelpDesk_RequestType::setIsCustomerRelated()
     * @uses HelpDesk_RequestType::setIsProductRelated()
     * @uses HelpDesk_RequestType::setIsSystem()
     * @uses HelpDesk_RequestType::setMedia()
     * @uses HelpDesk_RequestType::setName()
     * @uses HelpDesk_RequestType::setNotifications()
     * @uses HelpDesk_RequestType::setOrganizationUnitId()
     * @uses HelpDesk_RequestType::setReminders()
     * @uses HelpDesk_RequestType::setRequestCategory()
     * @uses HelpDesk_RequestType::setSecurity()
     * @uses HelpDesk_RequestType::setSellerScreenName()
     * @uses HelpDesk_RequestType::setStatuses()
     * @uses HelpDesk_RequestType::setUnifyScreenName()
     * @uses HelpDesk_RequestType::setUsersMayAddRequestsManually()
     * @uses HelpDesk_RequestType::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $administratorScreenName
     * @param string $defaultAssignTo
     * @param string $defaultAssignToDisplayString
     * @param \patest\StructType\GlobalString $description
     * @param bool $displayOnline
     * @param string $endClientScreenName
     * @param string $entityName
     * @param bool $isActive
     * @param bool $isCustomerRelated
     * @param bool $isProductRelated
     * @param bool $isSystem
     * @param \patest\StructType\HelpDesk_Media $media
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition $notifications
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfHelpDesk_ReminderDefinition $reminders
     * @param string $requestCategory
     * @param \patest\StructType\RecordSetOfHelpDesk_SecurityDefinitionsForRequestType $security
     * @param string $sellerScreenName
     * @param \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses
     * @param string $unifyScreenName
     * @param bool $usersMayAddRequestsManually
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $administratorScreenName = null, $defaultAssignTo = null, $defaultAssignToDisplayString = null, \patest\StructType\GlobalString $description = null, $displayOnline = null, $endClientScreenName = null, $entityName = null, $isActive = null, $isCustomerRelated = null, $isProductRelated = null, $isSystem = null, \patest\StructType\HelpDesk_Media $media = null, \patest\StructType\GlobalString $name = null, \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition $notifications = null, $organizationUnitId = null, \patest\StructType\RecordSetOfHelpDesk_ReminderDefinition $reminders = null, $requestCategory = null, \patest\StructType\RecordSetOfHelpDesk_SecurityDefinitionsForRequestType $security = null, $sellerScreenName = null, \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses = null, $unifyScreenName = null, $usersMayAddRequestsManually = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAdministratorScreenName($administratorScreenName)
            ->setDefaultAssignTo($defaultAssignTo)
            ->setDefaultAssignToDisplayString($defaultAssignToDisplayString)
            ->setDescription($description)
            ->setDisplayOnline($displayOnline)
            ->setEndClientScreenName($endClientScreenName)
            ->setEntityName($entityName)
            ->setIsActive($isActive)
            ->setIsCustomerRelated($isCustomerRelated)
            ->setIsProductRelated($isProductRelated)
            ->setIsSystem($isSystem)
            ->setMedia($media)
            ->setName($name)
            ->setNotifications($notifications)
            ->setOrganizationUnitId($organizationUnitId)
            ->setReminders($reminders)
            ->setRequestCategory($requestCategory)
            ->setSecurity($security)
            ->setSellerScreenName($sellerScreenName)
            ->setStatuses($statuses)
            ->setUnifyScreenName($unifyScreenName)
            ->setUsersMayAddRequestsManually($usersMayAddRequestsManually)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AdministratorScreenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdministratorScreenName()
    {
        return isset($this->AdministratorScreenName) ? $this->AdministratorScreenName : null;
    }
    /**
     * Set AdministratorScreenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $administratorScreenName
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setAdministratorScreenName($administratorScreenName = null)
    {
        // validation for constraint: string
        if (!is_null($administratorScreenName) && !is_string($administratorScreenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($administratorScreenName, true), gettype($administratorScreenName)), __LINE__);
        }
        if (is_null($administratorScreenName) || (is_array($administratorScreenName) && empty($administratorScreenName))) {
            unset($this->AdministratorScreenName);
        } else {
            $this->AdministratorScreenName = $administratorScreenName;
        }
        return $this;
    }
    /**
     * Get DefaultAssignTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAssignTo()
    {
        return isset($this->DefaultAssignTo) ? $this->DefaultAssignTo : null;
    }
    /**
     * Set DefaultAssignTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAssignTo
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setDefaultAssignTo($defaultAssignTo = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAssignTo) && !is_string($defaultAssignTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAssignTo, true), gettype($defaultAssignTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAssignTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAssignTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAssignTo, true)), __LINE__);
        }
        if (is_null($defaultAssignTo) || (is_array($defaultAssignTo) && empty($defaultAssignTo))) {
            unset($this->DefaultAssignTo);
        } else {
            $this->DefaultAssignTo = $defaultAssignTo;
        }
        return $this;
    }
    /**
     * Get DefaultAssignToDisplayString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAssignToDisplayString()
    {
        return isset($this->DefaultAssignToDisplayString) ? $this->DefaultAssignToDisplayString : null;
    }
    /**
     * Set DefaultAssignToDisplayString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAssignToDisplayString
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setDefaultAssignToDisplayString($defaultAssignToDisplayString = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAssignToDisplayString) && !is_string($defaultAssignToDisplayString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAssignToDisplayString, true), gettype($defaultAssignToDisplayString)), __LINE__);
        }
        if (is_null($defaultAssignToDisplayString) || (is_array($defaultAssignToDisplayString) && empty($defaultAssignToDisplayString))) {
            unset($this->DefaultAssignToDisplayString);
        } else {
            $this->DefaultAssignToDisplayString = $defaultAssignToDisplayString;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayOnline()
    {
        return isset($this->DisplayOnline) ? $this->DisplayOnline : null;
    }
    /**
     * Set DisplayOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayOnline
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setDisplayOnline($displayOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayOnline) && !is_bool($displayOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayOnline, true), gettype($displayOnline)), __LINE__);
        }
        if (is_null($displayOnline) || (is_array($displayOnline) && empty($displayOnline))) {
            unset($this->DisplayOnline);
        } else {
            $this->DisplayOnline = $displayOnline;
        }
        return $this;
    }
    /**
     * Get EndClientScreenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndClientScreenName()
    {
        return isset($this->EndClientScreenName) ? $this->EndClientScreenName : null;
    }
    /**
     * Set EndClientScreenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endClientScreenName
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setEndClientScreenName($endClientScreenName = null)
    {
        // validation for constraint: string
        if (!is_null($endClientScreenName) && !is_string($endClientScreenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endClientScreenName, true), gettype($endClientScreenName)), __LINE__);
        }
        if (is_null($endClientScreenName) || (is_array($endClientScreenName) && empty($endClientScreenName))) {
            unset($this->EndClientScreenName);
        } else {
            $this->EndClientScreenName = $endClientScreenName;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsCustomerRelated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCustomerRelated()
    {
        return isset($this->IsCustomerRelated) ? $this->IsCustomerRelated : null;
    }
    /**
     * Set IsCustomerRelated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCustomerRelated
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setIsCustomerRelated($isCustomerRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCustomerRelated) && !is_bool($isCustomerRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCustomerRelated, true), gettype($isCustomerRelated)), __LINE__);
        }
        if (is_null($isCustomerRelated) || (is_array($isCustomerRelated) && empty($isCustomerRelated))) {
            unset($this->IsCustomerRelated);
        } else {
            $this->IsCustomerRelated = $isCustomerRelated;
        }
        return $this;
    }
    /**
     * Get IsProductRelated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProductRelated()
    {
        return isset($this->IsProductRelated) ? $this->IsProductRelated : null;
    }
    /**
     * Set IsProductRelated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProductRelated
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setIsProductRelated($isProductRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductRelated) && !is_bool($isProductRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductRelated, true), gettype($isProductRelated)), __LINE__);
        }
        if (is_null($isProductRelated) || (is_array($isProductRelated) && empty($isProductRelated))) {
            unset($this->IsProductRelated);
        } else {
            $this->IsProductRelated = $isProductRelated;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HelpDesk_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\HelpDesk_Media $media
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setMedia(\patest\StructType\HelpDesk_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition|null
     */
    public function getNotifications()
    {
        return isset($this->Notifications) ? $this->Notifications : null;
    }
    /**
     * Set Notifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition $notifications
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setNotifications(\patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition $notifications = null)
    {
        if (is_null($notifications) || (is_array($notifications) && empty($notifications))) {
            unset($this->Notifications);
        } else {
            $this->Notifications = $notifications;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Reminders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_ReminderDefinition|null
     */
    public function getReminders()
    {
        return isset($this->Reminders) ? $this->Reminders : null;
    }
    /**
     * Set Reminders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_ReminderDefinition $reminders
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setReminders(\patest\StructType\RecordSetOfHelpDesk_ReminderDefinition $reminders = null)
    {
        if (is_null($reminders) || (is_array($reminders) && empty($reminders))) {
            unset($this->Reminders);
        } else {
            $this->Reminders = $reminders;
        }
        return $this;
    }
    /**
     * Get RequestCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestCategory()
    {
        return isset($this->RequestCategory) ? $this->RequestCategory : null;
    }
    /**
     * Set RequestCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestCategory
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setRequestCategory($requestCategory = null)
    {
        // validation for constraint: string
        if (!is_null($requestCategory) && !is_string($requestCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCategory, true), gettype($requestCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestCategory, true)), __LINE__);
        }
        if (is_null($requestCategory) || (is_array($requestCategory) && empty($requestCategory))) {
            unset($this->RequestCategory);
        } else {
            $this->RequestCategory = $requestCategory;
        }
        return $this;
    }
    /**
     * Get Security value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_SecurityDefinitionsForRequestType|null
     */
    public function getSecurity()
    {
        return isset($this->Security) ? $this->Security : null;
    }
    /**
     * Set Security value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_SecurityDefinitionsForRequestType $security
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setSecurity(\patest\StructType\RecordSetOfHelpDesk_SecurityDefinitionsForRequestType $security = null)
    {
        if (is_null($security) || (is_array($security) && empty($security))) {
            unset($this->Security);
        } else {
            $this->Security = $security;
        }
        return $this;
    }
    /**
     * Get SellerScreenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerScreenName()
    {
        return isset($this->SellerScreenName) ? $this->SellerScreenName : null;
    }
    /**
     * Set SellerScreenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerScreenName
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setSellerScreenName($sellerScreenName = null)
    {
        // validation for constraint: string
        if (!is_null($sellerScreenName) && !is_string($sellerScreenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerScreenName, true), gettype($sellerScreenName)), __LINE__);
        }
        if (is_null($sellerScreenName) || (is_array($sellerScreenName) && empty($sellerScreenName))) {
            unset($this->SellerScreenName);
        } else {
            $this->SellerScreenName = $sellerScreenName;
        }
        return $this;
    }
    /**
     * Get Statuses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage|null
     */
    public function getStatuses()
    {
        return isset($this->Statuses) ? $this->Statuses : null;
    }
    /**
     * Set Statuses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setStatuses(\patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses = null)
    {
        if (is_null($statuses) || (is_array($statuses) && empty($statuses))) {
            unset($this->Statuses);
        } else {
            $this->Statuses = $statuses;
        }
        return $this;
    }
    /**
     * Get UnifyScreenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnifyScreenName()
    {
        return isset($this->UnifyScreenName) ? $this->UnifyScreenName : null;
    }
    /**
     * Set UnifyScreenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unifyScreenName
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setUnifyScreenName($unifyScreenName = null)
    {
        // validation for constraint: string
        if (!is_null($unifyScreenName) && !is_string($unifyScreenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unifyScreenName, true), gettype($unifyScreenName)), __LINE__);
        }
        if (is_null($unifyScreenName) || (is_array($unifyScreenName) && empty($unifyScreenName))) {
            unset($this->UnifyScreenName);
        } else {
            $this->UnifyScreenName = $unifyScreenName;
        }
        return $this;
    }
    /**
     * Get UsersMayAddRequestsManually value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsersMayAddRequestsManually()
    {
        return isset($this->UsersMayAddRequestsManually) ? $this->UsersMayAddRequestsManually : null;
    }
    /**
     * Set UsersMayAddRequestsManually value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usersMayAddRequestsManually
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setUsersMayAddRequestsManually($usersMayAddRequestsManually = null)
    {
        // validation for constraint: boolean
        if (!is_null($usersMayAddRequestsManually) && !is_bool($usersMayAddRequestsManually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usersMayAddRequestsManually, true), gettype($usersMayAddRequestsManually)), __LINE__);
        }
        if (is_null($usersMayAddRequestsManually) || (is_array($usersMayAddRequestsManually) && empty($usersMayAddRequestsManually))) {
            unset($this->UsersMayAddRequestsManually);
        } else {
            $this->UsersMayAddRequestsManually = $usersMayAddRequestsManually;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\HelpDesk_RequestType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
