<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.RequestNotificationDefinition StructType
 * @subpackage Structs
 */
class HelpDesk_RequestNotificationDefinition extends PersistableEntity
{
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EmailSubject;
    /**
     * The RecipientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecipientType;
    /**
     * The SpecificEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificEmail;
    /**
     * The SpecifiedUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpecifiedUser;
    /**
     * The TriggerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TriggerType;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for HelpDesk.RequestNotificationDefinition
     * @uses HelpDesk_RequestNotificationDefinition::setDocumentId()
     * @uses HelpDesk_RequestNotificationDefinition::setEmailSubject()
     * @uses HelpDesk_RequestNotificationDefinition::setRecipientType()
     * @uses HelpDesk_RequestNotificationDefinition::setSpecificEmail()
     * @uses HelpDesk_RequestNotificationDefinition::setSpecifiedUser()
     * @uses HelpDesk_RequestNotificationDefinition::setTriggerType()
     * @uses HelpDesk_RequestNotificationDefinition::setTypeId()
     * @param string $documentId
     * @param \patest\StructType\GlobalString $emailSubject
     * @param string $recipientType
     * @param string $specificEmail
     * @param string $specifiedUser
     * @param string $triggerType
     * @param string $typeId
     */
    public function __construct($documentId = null, \patest\StructType\GlobalString $emailSubject = null, $recipientType = null, $specificEmail = null, $specifiedUser = null, $triggerType = null, $typeId = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setEmailSubject($emailSubject)
            ->setRecipientType($recipientType)
            ->setSpecificEmail($specificEmail)
            ->setSpecifiedUser($specifiedUser)
            ->setTriggerType($triggerType)
            ->setTypeId($typeId);
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $emailSubject
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setEmailSubject(\patest\StructType\GlobalString $emailSubject = null)
    {
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
    /**
     * Get RecipientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipientType()
    {
        return isset($this->RecipientType) ? $this->RecipientType : null;
    }
    /**
     * Set RecipientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServiceRequestNotificationRecipientType::valueIsValid()
     * @uses \patest\EnumType\ServiceRequestNotificationRecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recipientType
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setRecipientType($recipientType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServiceRequestNotificationRecipientType::valueIsValid($recipientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServiceRequestNotificationRecipientType', is_array($recipientType) ? implode(', ', $recipientType) : var_export($recipientType, true), implode(', ', \patest\EnumType\ServiceRequestNotificationRecipientType::getValidValues())), __LINE__);
        }
        if (is_null($recipientType) || (is_array($recipientType) && empty($recipientType))) {
            unset($this->RecipientType);
        } else {
            $this->RecipientType = $recipientType;
        }
        return $this;
    }
    /**
     * Get SpecificEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificEmail()
    {
        return isset($this->SpecificEmail) ? $this->SpecificEmail : null;
    }
    /**
     * Set SpecificEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificEmail
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setSpecificEmail($specificEmail = null)
    {
        // validation for constraint: string
        if (!is_null($specificEmail) && !is_string($specificEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificEmail, true), gettype($specificEmail)), __LINE__);
        }
        if (is_null($specificEmail) || (is_array($specificEmail) && empty($specificEmail))) {
            unset($this->SpecificEmail);
        } else {
            $this->SpecificEmail = $specificEmail;
        }
        return $this;
    }
    /**
     * Get SpecifiedUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecifiedUser()
    {
        return isset($this->SpecifiedUser) ? $this->SpecifiedUser : null;
    }
    /**
     * Set SpecifiedUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specifiedUser
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setSpecifiedUser($specifiedUser = null)
    {
        // validation for constraint: string
        if (!is_null($specifiedUser) && !is_string($specifiedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specifiedUser, true), gettype($specifiedUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($specifiedUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $specifiedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($specifiedUser, true)), __LINE__);
        }
        if (is_null($specifiedUser) || (is_array($specifiedUser) && empty($specifiedUser))) {
            unset($this->SpecifiedUser);
        } else {
            $this->SpecifiedUser = $specifiedUser;
        }
        return $this;
    }
    /**
     * Get TriggerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTriggerType()
    {
        return isset($this->TriggerType) ? $this->TriggerType : null;
    }
    /**
     * Set TriggerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServiceRequestNotificationTriggerType::valueIsValid()
     * @uses \patest\EnumType\ServiceRequestNotificationTriggerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $triggerType
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setTriggerType($triggerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServiceRequestNotificationTriggerType::valueIsValid($triggerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServiceRequestNotificationTriggerType', is_array($triggerType) ? implode(', ', $triggerType) : var_export($triggerType, true), implode(', ', \patest\EnumType\ServiceRequestNotificationTriggerType::getValidValues())), __LINE__);
        }
        if (is_null($triggerType) || (is_array($triggerType) && empty($triggerType))) {
            unset($this->TriggerType);
        } else {
            $this->TriggerType = $triggerType;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
