<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HallDisplayStyle StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HallDisplayStyle
 * @subpackage Structs
 */
class HallDisplayStyle extends AbstractStructBase
{
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PropertyName;
    /**
     * The PropertyValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyValue;
    /**
     * Constructor method for HallDisplayStyle
     * @uses HallDisplayStyle::setPropertyName()
     * @uses HallDisplayStyle::setPropertyValue()
     * @param string $propertyName
     * @param string $propertyValue
     */
    public function __construct($propertyName = null, $propertyValue = null)
    {
        $this
            ->setPropertyName($propertyName)
            ->setPropertyValue($propertyValue);
    }
    /**
     * Get PropertyName value
     * @return string|null
     */
    public function getPropertyName()
    {
        return $this->PropertyName;
    }
    /**
     * Set PropertyName value
     * @uses \patest\EnumType\DisplayTypes::valueIsValid()
     * @uses \patest\EnumType\DisplayTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyName
     * @return \patest\StructType\HallDisplayStyle
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DisplayTypes::valueIsValid($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DisplayTypes', is_array($propertyName) ? implode(', ', $propertyName) : var_export($propertyName, true), implode(', ', \patest\EnumType\DisplayTypes::getValidValues())), __LINE__);
        }
        $this->PropertyName = $propertyName;
        return $this;
    }
    /**
     * Get PropertyValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyValue()
    {
        return isset($this->PropertyValue) ? $this->PropertyValue : null;
    }
    /**
     * Set PropertyValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyValue
     * @return \patest\StructType\HallDisplayStyle
     */
    public function setPropertyValue($propertyValue = null)
    {
        // validation for constraint: string
        if (!is_null($propertyValue) && !is_string($propertyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyValue, true), gettype($propertyValue)), __LINE__);
        }
        if (is_null($propertyValue) || (is_array($propertyValue) && empty($propertyValue))) {
            unset($this->PropertyValue);
        } else {
            $this->PropertyValue = $propertyValue;
        }
        return $this;
    }
}
