<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HallDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HallDesign
 * @subpackage Structs
 */
class HallDesign extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The BackgroundImages3D
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BackgroundImages3D;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The HallGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallGuid;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The VenueGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueGuid;
    /**
     * The Venue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\VenueDesign
     */
    public $Venue;
    /**
     * The StageImageUrlId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StageImageUrlId;
    /**
     * Constructor method for HallDesign
     * @uses HallDesign::setActive()
     * @uses HallDesign::setBackgroundImages3D()
     * @uses HallDesign::setExternalReference()
     * @uses HallDesign::setHallGuid()
     * @uses HallDesign::setName()
     * @uses HallDesign::setVenueGuid()
     * @uses HallDesign::setVenue()
     * @uses HallDesign::setStageImageUrlId()
     * @param bool $active
     * @param bool $backgroundImages3D
     * @param string $externalReference
     * @param string $hallGuid
     * @param \patest\StructType\GlobalString $name
     * @param string $venueGuid
     * @param \patest\StructType\VenueDesign $venue
     * @param int $stageImageUrlId
     */
    public function __construct($active = null, $backgroundImages3D = null, $externalReference = null, $hallGuid = null, \patest\StructType\GlobalString $name = null, $venueGuid = null, \patest\StructType\VenueDesign $venue = null, $stageImageUrlId = null)
    {
        $this
            ->setActive($active)
            ->setBackgroundImages3D($backgroundImages3D)
            ->setExternalReference($externalReference)
            ->setHallGuid($hallGuid)
            ->setName($name)
            ->setVenueGuid($venueGuid)
            ->setVenue($venue)
            ->setStageImageUrlId($stageImageUrlId);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \patest\StructType\HallDesign
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BackgroundImages3D value
     * @return bool|null
     */
    public function getBackgroundImages3D()
    {
        return $this->BackgroundImages3D;
    }
    /**
     * Set BackgroundImages3D value
     * @param bool $backgroundImages3D
     * @return \patest\StructType\HallDesign
     */
    public function setBackgroundImages3D($backgroundImages3D = null)
    {
        // validation for constraint: boolean
        if (!is_null($backgroundImages3D) && !is_bool($backgroundImages3D)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($backgroundImages3D, true), gettype($backgroundImages3D)), __LINE__);
        }
        $this->BackgroundImages3D = $backgroundImages3D;
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \patest\StructType\HallDesign
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get HallGuid value
     * @return string|null
     */
    public function getHallGuid()
    {
        return $this->HallGuid;
    }
    /**
     * Set HallGuid value
     * @param string $hallGuid
     * @return \patest\StructType\HallDesign
     */
    public function setHallGuid($hallGuid = null)
    {
        // validation for constraint: string
        if (!is_null($hallGuid) && !is_string($hallGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallGuid, true), gettype($hallGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallGuid, true)), __LINE__);
        }
        $this->HallGuid = $hallGuid;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\HallDesign
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get VenueGuid value
     * @return string|null
     */
    public function getVenueGuid()
    {
        return $this->VenueGuid;
    }
    /**
     * Set VenueGuid value
     * @param string $venueGuid
     * @return \patest\StructType\HallDesign
     */
    public function setVenueGuid($venueGuid = null)
    {
        // validation for constraint: string
        if (!is_null($venueGuid) && !is_string($venueGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueGuid, true), gettype($venueGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueGuid, true)), __LINE__);
        }
        $this->VenueGuid = $venueGuid;
        return $this;
    }
    /**
     * Get Venue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\VenueDesign|null
     */
    public function getVenue()
    {
        return isset($this->Venue) ? $this->Venue : null;
    }
    /**
     * Set Venue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\VenueDesign $venue
     * @return \patest\StructType\HallDesign
     */
    public function setVenue(\patest\StructType\VenueDesign $venue = null)
    {
        if (is_null($venue) || (is_array($venue) && empty($venue))) {
            unset($this->Venue);
        } else {
            $this->Venue = $venue;
        }
        return $this;
    }
    /**
     * Get StageImageUrlId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStageImageUrlId()
    {
        return isset($this->StageImageUrlId) ? $this->StageImageUrlId : null;
    }
    /**
     * Set StageImageUrlId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stageImageUrlId
     * @return \patest\StructType\HallDesign
     */
    public function setStageImageUrlId($stageImageUrlId = null)
    {
        // validation for constraint: int
        if (!is_null($stageImageUrlId) && !(is_int($stageImageUrlId) || ctype_digit($stageImageUrlId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stageImageUrlId, true), gettype($stageImageUrlId)), __LINE__);
        }
        if (is_null($stageImageUrlId) || (is_array($stageImageUrlId) && empty($stageImageUrlId))) {
            unset($this->StageImageUrlId);
        } else {
            $this->StageImageUrlId = $stageImageUrlId;
        }
        return $this;
    }
}
