<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HallDataDictionaryTable StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HallDataDictionaryTable
 * @subpackage Structs
 */
class HallDataDictionaryTable extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Entries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfanyTypeHallDataDictionaryEntryvEzo7Bse
     */
    public $Entries;
    /**
     * The MaskPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaskPercentage;
    /**
     * The MaskType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaskType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The TextColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextColor;
    /**
     * Constructor method for HallDataDictionaryTable
     * @uses HallDataDictionaryTable::setActive()
     * @uses HallDataDictionaryTable::setEntries()
     * @uses HallDataDictionaryTable::setMaskPercentage()
     * @uses HallDataDictionaryTable::setMaskType()
     * @uses HallDataDictionaryTable::setName()
     * @uses HallDataDictionaryTable::setOrdinal()
     * @uses HallDataDictionaryTable::setTextColor()
     * @param bool $active
     * @param \patest\ArrayType\ArrayOfKeyValueOfanyTypeHallDataDictionaryEntryvEzo7Bse $entries
     * @param int $maskPercentage
     * @param string $maskType
     * @param string $name
     * @param int $ordinal
     * @param string $textColor
     */
    public function __construct($active = null, \patest\ArrayType\ArrayOfKeyValueOfanyTypeHallDataDictionaryEntryvEzo7Bse $entries = null, $maskPercentage = null, $maskType = null, $name = null, $ordinal = null, $textColor = null)
    {
        $this
            ->setActive($active)
            ->setEntries($entries)
            ->setMaskPercentage($maskPercentage)
            ->setMaskType($maskType)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setTextColor($textColor);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Entries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfanyTypeHallDataDictionaryEntryvEzo7Bse|null
     */
    public function getEntries()
    {
        return isset($this->Entries) ? $this->Entries : null;
    }
    /**
     * Set Entries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfanyTypeHallDataDictionaryEntryvEzo7Bse $entries
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setEntries(\patest\ArrayType\ArrayOfKeyValueOfanyTypeHallDataDictionaryEntryvEzo7Bse $entries = null)
    {
        if (is_null($entries) || (is_array($entries) && empty($entries))) {
            unset($this->Entries);
        } else {
            $this->Entries = $entries;
        }
        return $this;
    }
    /**
     * Get MaskPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaskPercentage()
    {
        return isset($this->MaskPercentage) ? $this->MaskPercentage : null;
    }
    /**
     * Set MaskPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maskPercentage
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setMaskPercentage($maskPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($maskPercentage) && !(is_int($maskPercentage) || ctype_digit($maskPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maskPercentage, true), gettype($maskPercentage)), __LINE__);
        }
        if (is_null($maskPercentage) || (is_array($maskPercentage) && empty($maskPercentage))) {
            unset($this->MaskPercentage);
        } else {
            $this->MaskPercentage = $maskPercentage;
        }
        return $this;
    }
    /**
     * Get MaskType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaskType()
    {
        return isset($this->MaskType) ? $this->MaskType : null;
    }
    /**
     * Set MaskType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MaskTypes::valueIsValid()
     * @uses \patest\EnumType\MaskTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maskType
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setMaskType($maskType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MaskTypes::valueIsValid($maskType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MaskTypes', is_array($maskType) ? implode(', ', $maskType) : var_export($maskType, true), implode(', ', \patest\EnumType\MaskTypes::getValidValues())), __LINE__);
        }
        if (is_null($maskType) || (is_array($maskType) && empty($maskType))) {
            unset($this->MaskType);
        } else {
            $this->MaskType = $maskType;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @uses \patest\EnumType\HallDataTableNames::valueIsValid()
     * @uses \patest\EnumType\HallDataTableNames::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $name
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setName($name = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallDataTableNames::valueIsValid($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallDataTableNames', is_array($name) ? implode(', ', $name) : var_export($name, true), implode(', ', \patest\EnumType\HallDataTableNames::getValidValues())), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get TextColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextColor()
    {
        return isset($this->TextColor) ? $this->TextColor : null;
    }
    /**
     * Set TextColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textColor
     * @return \patest\StructType\HallDataDictionaryTable
     */
    public function setTextColor($textColor = null)
    {
        // validation for constraint: string
        if (!is_null($textColor) && !is_string($textColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textColor, true), gettype($textColor)), __LINE__);
        }
        if (is_null($textColor) || (is_array($textColor) && empty($textColor))) {
            unset($this->TextColor);
        } else {
            $this->TextColor = $textColor;
        }
        return $this;
    }
}
