<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupedBasketNode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupedBasketNode
 * @subpackage Structs
 */
class GroupedBasketNode extends AbstractStructBase
{
    /**
     * The AmountToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AmountToPay;
    /**
     * The Children
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGroupedBasketNode
     */
    public $Children;
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CommissionAmount;
    /**
     * The DetailsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailsText;
    /**
     * The DetailsTextForPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailsTextForPrint;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DiscountAmount;
    /**
     * The ExtraChargeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExtraChargeAmount;
    /**
     * The FinancialJournalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public $FinancialJournalInfo;
    /**
     * The Flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Flags;
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupType;
    /**
     * The InsideCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InsideCommissionAmount;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The IsInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsInactive;
    /**
     * The IsSameProductGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSameProductGroup;
    /**
     * The ItemDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $ItemDetails;
    /**
     * The ItemOrPriceModifierId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemOrPriceModifierId;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemTypeId;
    /**
     * The ListPriceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ListPriceAmount;
    /**
     * The NodeTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NodeTitle;
    /**
     * The NodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NodeType;
    /**
     * The NodeTypeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NodeTypeText;
    /**
     * The PaidDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaidDetails;
    /**
     * The PaidStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaidStatus;
    /**
     * The PriceModifierType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceModifierType;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Qty;
    /**
     * The SubsidyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SubsidyAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The ThirdPartyVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ThirdPartyVatAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * The ValidationErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationErrors;
    /**
     * The VatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VatAmount;
    /**
     * The EventDateDetailsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateDetailsText;
    /**
     * The RegularPriceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RegularPriceAmount;
    /**
     * The IsInExchangeMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsInExchangeMode;
    /**
     * The IsRepriceMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRepriceMode;
    /**
     * The AccessCodeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCodeText;
    /**
     * Constructor method for GroupedBasketNode
     * @uses GroupedBasketNode::setAmountToPay()
     * @uses GroupedBasketNode::setChildren()
     * @uses GroupedBasketNode::setCommissionAmount()
     * @uses GroupedBasketNode::setDetailsText()
     * @uses GroupedBasketNode::setDetailsTextForPrint()
     * @uses GroupedBasketNode::setDiscountAmount()
     * @uses GroupedBasketNode::setExtraChargeAmount()
     * @uses GroupedBasketNode::setFinancialJournalInfo()
     * @uses GroupedBasketNode::setFlags()
     * @uses GroupedBasketNode::setGroupType()
     * @uses GroupedBasketNode::setInsideCommissionAmount()
     * @uses GroupedBasketNode::setInsuranceAmount()
     * @uses GroupedBasketNode::setIsInactive()
     * @uses GroupedBasketNode::setIsSameProductGroup()
     * @uses GroupedBasketNode::setItemDetails()
     * @uses GroupedBasketNode::setItemOrPriceModifierId()
     * @uses GroupedBasketNode::setItemTypeId()
     * @uses GroupedBasketNode::setListPriceAmount()
     * @uses GroupedBasketNode::setNodeTitle()
     * @uses GroupedBasketNode::setNodeType()
     * @uses GroupedBasketNode::setNodeTypeText()
     * @uses GroupedBasketNode::setPaidDetails()
     * @uses GroupedBasketNode::setPaidStatus()
     * @uses GroupedBasketNode::setPriceModifierType()
     * @uses GroupedBasketNode::setPriceTypeId()
     * @uses GroupedBasketNode::setPriceTypeName()
     * @uses GroupedBasketNode::setProductId()
     * @uses GroupedBasketNode::setQty()
     * @uses GroupedBasketNode::setSubsidyAmount()
     * @uses GroupedBasketNode::setTaxAmount()
     * @uses GroupedBasketNode::setThirdPartyVatAmount()
     * @uses GroupedBasketNode::setTotalAmount()
     * @uses GroupedBasketNode::setValidationErrors()
     * @uses GroupedBasketNode::setVatAmount()
     * @uses GroupedBasketNode::setEventDateDetailsText()
     * @uses GroupedBasketNode::setRegularPriceAmount()
     * @uses GroupedBasketNode::setIsInExchangeMode()
     * @uses GroupedBasketNode::setIsRepriceMode()
     * @uses GroupedBasketNode::setAccessCodeText()
     * @param float $amountToPay
     * @param \patest\ArrayType\ArrayOfGroupedBasketNode $children
     * @param float $commissionAmount
     * @param string $detailsText
     * @param string $detailsTextForPrint
     * @param float $discountAmount
     * @param float $extraChargeAmount
     * @param \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo
     * @param string[] $flags
     * @param string $groupType
     * @param float $insideCommissionAmount
     * @param float $insuranceAmount
     * @param bool $isInactive
     * @param bool $isSameProductGroup
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @param int $itemOrPriceModifierId
     * @param int $itemTypeId
     * @param float $listPriceAmount
     * @param string $nodeTitle
     * @param string $nodeType
     * @param string $nodeTypeText
     * @param string $paidDetails
     * @param string $paidStatus
     * @param string $priceModifierType
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string $productId
     * @param int $qty
     * @param float $subsidyAmount
     * @param float $taxAmount
     * @param float $thirdPartyVatAmount
     * @param float $totalAmount
     * @param string $validationErrors
     * @param float $vatAmount
     * @param string $eventDateDetailsText
     * @param float $regularPriceAmount
     * @param bool $isInExchangeMode
     * @param bool $isRepriceMode
     * @param string $accessCodeText
     */
    public function __construct($amountToPay = null, \patest\ArrayType\ArrayOfGroupedBasketNode $children = null, $commissionAmount = null, $detailsText = null, $detailsTextForPrint = null, $discountAmount = null, $extraChargeAmount = null, \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo = null, array $flags = array(), $groupType = null, $insideCommissionAmount = null, $insuranceAmount = null, $isInactive = null, $isSameProductGroup = null, \patest\StructType\Sales_AbstractItemDetails $itemDetails = null, $itemOrPriceModifierId = null, $itemTypeId = null, $listPriceAmount = null, $nodeTitle = null, $nodeType = null, $nodeTypeText = null, $paidDetails = null, $paidStatus = null, $priceModifierType = null, $priceTypeId = null, $priceTypeName = null, $productId = null, $qty = null, $subsidyAmount = null, $taxAmount = null, $thirdPartyVatAmount = null, $totalAmount = null, $validationErrors = null, $vatAmount = null, $eventDateDetailsText = null, $regularPriceAmount = null, $isInExchangeMode = null, $isRepriceMode = null, $accessCodeText = null)
    {
        $this
            ->setAmountToPay($amountToPay)
            ->setChildren($children)
            ->setCommissionAmount($commissionAmount)
            ->setDetailsText($detailsText)
            ->setDetailsTextForPrint($detailsTextForPrint)
            ->setDiscountAmount($discountAmount)
            ->setExtraChargeAmount($extraChargeAmount)
            ->setFinancialJournalInfo($financialJournalInfo)
            ->setFlags($flags)
            ->setGroupType($groupType)
            ->setInsideCommissionAmount($insideCommissionAmount)
            ->setInsuranceAmount($insuranceAmount)
            ->setIsInactive($isInactive)
            ->setIsSameProductGroup($isSameProductGroup)
            ->setItemDetails($itemDetails)
            ->setItemOrPriceModifierId($itemOrPriceModifierId)
            ->setItemTypeId($itemTypeId)
            ->setListPriceAmount($listPriceAmount)
            ->setNodeTitle($nodeTitle)
            ->setNodeType($nodeType)
            ->setNodeTypeText($nodeTypeText)
            ->setPaidDetails($paidDetails)
            ->setPaidStatus($paidStatus)
            ->setPriceModifierType($priceModifierType)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setProductId($productId)
            ->setQty($qty)
            ->setSubsidyAmount($subsidyAmount)
            ->setTaxAmount($taxAmount)
            ->setThirdPartyVatAmount($thirdPartyVatAmount)
            ->setTotalAmount($totalAmount)
            ->setValidationErrors($validationErrors)
            ->setVatAmount($vatAmount)
            ->setEventDateDetailsText($eventDateDetailsText)
            ->setRegularPriceAmount($regularPriceAmount)
            ->setIsInExchangeMode($isInExchangeMode)
            ->setIsRepriceMode($isRepriceMode)
            ->setAccessCodeText($accessCodeText);
    }
    /**
     * Get AmountToPay value
     * @return float|null
     */
    public function getAmountToPay()
    {
        return $this->AmountToPay;
    }
    /**
     * Set AmountToPay value
     * @param float $amountToPay
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setAmountToPay($amountToPay = null)
    {
        // validation for constraint: float
        if (!is_null($amountToPay) && !(is_float($amountToPay) || is_numeric($amountToPay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountToPay, true), gettype($amountToPay)), __LINE__);
        }
        $this->AmountToPay = $amountToPay;
        return $this;
    }
    /**
     * Get Children value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGroupedBasketNode|null
     */
    public function getChildren()
    {
        return isset($this->Children) ? $this->Children : null;
    }
    /**
     * Set Children value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGroupedBasketNode $children
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setChildren(\patest\ArrayType\ArrayOfGroupedBasketNode $children = null)
    {
        if (is_null($children) || (is_array($children) && empty($children))) {
            unset($this->Children);
        } else {
            $this->Children = $children;
        }
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return float|null
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($commissionAmount) && !(is_float($commissionAmount) || is_numeric($commissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionAmount, true), gettype($commissionAmount)), __LINE__);
        }
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get DetailsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailsText()
    {
        return isset($this->DetailsText) ? $this->DetailsText : null;
    }
    /**
     * Set DetailsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailsText
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setDetailsText($detailsText = null)
    {
        // validation for constraint: string
        if (!is_null($detailsText) && !is_string($detailsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailsText, true), gettype($detailsText)), __LINE__);
        }
        if (is_null($detailsText) || (is_array($detailsText) && empty($detailsText))) {
            unset($this->DetailsText);
        } else {
            $this->DetailsText = $detailsText;
        }
        return $this;
    }
    /**
     * Get DetailsTextForPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailsTextForPrint()
    {
        return isset($this->DetailsTextForPrint) ? $this->DetailsTextForPrint : null;
    }
    /**
     * Set DetailsTextForPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailsTextForPrint
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setDetailsTextForPrint($detailsTextForPrint = null)
    {
        // validation for constraint: string
        if (!is_null($detailsTextForPrint) && !is_string($detailsTextForPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailsTextForPrint, true), gettype($detailsTextForPrint)), __LINE__);
        }
        if (is_null($detailsTextForPrint) || (is_array($detailsTextForPrint) && empty($detailsTextForPrint))) {
            unset($this->DetailsTextForPrint);
        } else {
            $this->DetailsTextForPrint = $detailsTextForPrint;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get ExtraChargeAmount value
     * @return float|null
     */
    public function getExtraChargeAmount()
    {
        return $this->ExtraChargeAmount;
    }
    /**
     * Set ExtraChargeAmount value
     * @param float $extraChargeAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setExtraChargeAmount($extraChargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($extraChargeAmount) && !(is_float($extraChargeAmount) || is_numeric($extraChargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extraChargeAmount, true), gettype($extraChargeAmount)), __LINE__);
        }
        $this->ExtraChargeAmount = $extraChargeAmount;
        return $this;
    }
    /**
     * Get FinancialJournalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionElementFinancialJournalInfo|null
     */
    public function getFinancialJournalInfo()
    {
        return isset($this->FinancialJournalInfo) ? $this->FinancialJournalInfo : null;
    }
    /**
     * Set FinancialJournalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setFinancialJournalInfo(\patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo = null)
    {
        if (is_null($financialJournalInfo) || (is_array($financialJournalInfo) && empty($financialJournalInfo))) {
            unset($this->FinancialJournalInfo);
        } else {
            $this->FinancialJournalInfo = $financialJournalInfo;
        }
        return $this;
    }
    /**
     * Get Flags value
     * @return string[]|null
     */
    public function getFlags()
    {
        return $this->Flags;
    }
    /**
     * This method is responsible for validating the values passed to the setFlags method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlags method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlagsForArrayConstraintsFromSetFlags(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $groupedBasketNodeFlagsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\GroupedBasketNodeFlags::valueIsValid($groupedBasketNodeFlagsItem)) {
                $invalidValues[] = is_object($groupedBasketNodeFlagsItem) ? get_class($groupedBasketNodeFlagsItem) : sprintf('%s(%s)', gettype($groupedBasketNodeFlagsItem), var_export($groupedBasketNodeFlagsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GroupedBasketNodeFlags', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\GroupedBasketNodeFlags::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Flags value
     * @uses \patest\EnumType\GroupedBasketNodeFlags::valueIsValid()
     * @uses \patest\EnumType\GroupedBasketNodeFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $flags
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setFlags(array $flags = array())
    {
        // validation for constraint: list
        if ('' !== ($flagsArrayErrorMessage = self::validateFlagsForArrayConstraintsFromSetFlags($flags))) {
            throw new \InvalidArgumentException($flagsArrayErrorMessage, __LINE__);
        }
        $this->Flags = is_array($flags) ? implode(' ', $flags) : null;
        return $this;
    }
    /**
     * Get GroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupType()
    {
        return isset($this->GroupType) ? $this->GroupType : null;
    }
    /**
     * Set GroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupType
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: string
        if (!is_null($groupType) && !is_string($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupType, true), gettype($groupType)), __LINE__);
        }
        if (is_null($groupType) || (is_array($groupType) && empty($groupType))) {
            unset($this->GroupType);
        } else {
            $this->GroupType = $groupType;
        }
        return $this;
    }
    /**
     * Get InsideCommissionAmount value
     * @return float|null
     */
    public function getInsideCommissionAmount()
    {
        return $this->InsideCommissionAmount;
    }
    /**
     * Set InsideCommissionAmount value
     * @param float $insideCommissionAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setInsideCommissionAmount($insideCommissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insideCommissionAmount) && !(is_float($insideCommissionAmount) || is_numeric($insideCommissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insideCommissionAmount, true), gettype($insideCommissionAmount)), __LINE__);
        }
        $this->InsideCommissionAmount = $insideCommissionAmount;
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float|null
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get IsInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->IsInactive;
    }
    /**
     * Set IsInactive value
     * @param bool $isInactive
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->IsInactive = $isInactive;
        return $this;
    }
    /**
     * Get IsSameProductGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSameProductGroup()
    {
        return isset($this->IsSameProductGroup) ? $this->IsSameProductGroup : null;
    }
    /**
     * Set IsSameProductGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSameProductGroup
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setIsSameProductGroup($isSameProductGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSameProductGroup) && !is_bool($isSameProductGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSameProductGroup, true), gettype($isSameProductGroup)), __LINE__);
        }
        if (is_null($isSameProductGroup) || (is_array($isSameProductGroup) && empty($isSameProductGroup))) {
            unset($this->IsSameProductGroup);
        } else {
            $this->IsSameProductGroup = $isSameProductGroup;
        }
        return $this;
    }
    /**
     * Get ItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getItemDetails()
    {
        return isset($this->ItemDetails) ? $this->ItemDetails : null;
    }
    /**
     * Set ItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setItemDetails(\patest\StructType\Sales_AbstractItemDetails $itemDetails = null)
    {
        if (is_null($itemDetails) || (is_array($itemDetails) && empty($itemDetails))) {
            unset($this->ItemDetails);
        } else {
            $this->ItemDetails = $itemDetails;
        }
        return $this;
    }
    /**
     * Get ItemOrPriceModifierId value
     * @return int|null
     */
    public function getItemOrPriceModifierId()
    {
        return $this->ItemOrPriceModifierId;
    }
    /**
     * Set ItemOrPriceModifierId value
     * @param int $itemOrPriceModifierId
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setItemOrPriceModifierId($itemOrPriceModifierId = null)
    {
        // validation for constraint: int
        if (!is_null($itemOrPriceModifierId) && !(is_int($itemOrPriceModifierId) || ctype_digit($itemOrPriceModifierId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemOrPriceModifierId, true), gettype($itemOrPriceModifierId)), __LINE__);
        }
        $this->ItemOrPriceModifierId = $itemOrPriceModifierId;
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemTypeId
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeId) && !(is_int($itemTypeId) || ctype_digit($itemTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get ListPriceAmount value
     * @return float|null
     */
    public function getListPriceAmount()
    {
        return $this->ListPriceAmount;
    }
    /**
     * Set ListPriceAmount value
     * @param float $listPriceAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setListPriceAmount($listPriceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($listPriceAmount) && !(is_float($listPriceAmount) || is_numeric($listPriceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($listPriceAmount, true), gettype($listPriceAmount)), __LINE__);
        }
        $this->ListPriceAmount = $listPriceAmount;
        return $this;
    }
    /**
     * Get NodeTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNodeTitle()
    {
        return isset($this->NodeTitle) ? $this->NodeTitle : null;
    }
    /**
     * Set NodeTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nodeTitle
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setNodeTitle($nodeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($nodeTitle) && !is_string($nodeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nodeTitle, true), gettype($nodeTitle)), __LINE__);
        }
        if (is_null($nodeTitle) || (is_array($nodeTitle) && empty($nodeTitle))) {
            unset($this->NodeTitle);
        } else {
            $this->NodeTitle = $nodeTitle;
        }
        return $this;
    }
    /**
     * Get NodeType value
     * @return string|null
     */
    public function getNodeType()
    {
        return $this->NodeType;
    }
    /**
     * Set NodeType value
     * @uses \patest\EnumType\GroupedBasketNodeType::valueIsValid()
     * @uses \patest\EnumType\GroupedBasketNodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeType
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setNodeType($nodeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GroupedBasketNodeType::valueIsValid($nodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GroupedBasketNodeType', is_array($nodeType) ? implode(', ', $nodeType) : var_export($nodeType, true), implode(', ', \patest\EnumType\GroupedBasketNodeType::getValidValues())), __LINE__);
        }
        $this->NodeType = $nodeType;
        return $this;
    }
    /**
     * Get NodeTypeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNodeTypeText()
    {
        return isset($this->NodeTypeText) ? $this->NodeTypeText : null;
    }
    /**
     * Set NodeTypeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nodeTypeText
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setNodeTypeText($nodeTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($nodeTypeText) && !is_string($nodeTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nodeTypeText, true), gettype($nodeTypeText)), __LINE__);
        }
        if (is_null($nodeTypeText) || (is_array($nodeTypeText) && empty($nodeTypeText))) {
            unset($this->NodeTypeText);
        } else {
            $this->NodeTypeText = $nodeTypeText;
        }
        return $this;
    }
    /**
     * Get PaidDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaidDetails()
    {
        return isset($this->PaidDetails) ? $this->PaidDetails : null;
    }
    /**
     * Set PaidDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paidDetails
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setPaidDetails($paidDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paidDetails) && !is_string($paidDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidDetails, true), gettype($paidDetails)), __LINE__);
        }
        if (is_null($paidDetails) || (is_array($paidDetails) && empty($paidDetails))) {
            unset($this->PaidDetails);
        } else {
            $this->PaidDetails = $paidDetails;
        }
        return $this;
    }
    /**
     * Get PaidStatus value
     * @return string|null
     */
    public function getPaidStatus()
    {
        return $this->PaidStatus;
    }
    /**
     * Set PaidStatus value
     * @uses \patest\EnumType\PaymentPaidStatusType::valueIsValid()
     * @uses \patest\EnumType\PaymentPaidStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paidStatus
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setPaidStatus($paidStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentPaidStatusType::valueIsValid($paidStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPaidStatusType', is_array($paidStatus) ? implode(', ', $paidStatus) : var_export($paidStatus, true), implode(', ', \patest\EnumType\PaymentPaidStatusType::getValidValues())), __LINE__);
        }
        $this->PaidStatus = $paidStatus;
        return $this;
    }
    /**
     * Get PriceModifierType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierType()
    {
        return isset($this->PriceModifierType) ? $this->PriceModifierType : null;
    }
    /**
     * Set PriceModifierType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceModifierType
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setPriceModifierType($priceModifierType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($priceModifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($priceModifierType) ? implode(', ', $priceModifierType) : var_export($priceModifierType, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        if (is_null($priceModifierType) || (is_array($priceModifierType) && empty($priceModifierType))) {
            unset($this->PriceModifierType);
        } else {
            $this->PriceModifierType = $priceModifierType;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get Qty value
     * @return int|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param int $qty
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get SubsidyAmount value
     * @return float|null
     */
    public function getSubsidyAmount()
    {
        return $this->SubsidyAmount;
    }
    /**
     * Set SubsidyAmount value
     * @param float $subsidyAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setSubsidyAmount($subsidyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($subsidyAmount) && !(is_float($subsidyAmount) || is_numeric($subsidyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subsidyAmount, true), gettype($subsidyAmount)), __LINE__);
        }
        $this->SubsidyAmount = $subsidyAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get ThirdPartyVatAmount value
     * @return float|null
     */
    public function getThirdPartyVatAmount()
    {
        return $this->ThirdPartyVatAmount;
    }
    /**
     * Set ThirdPartyVatAmount value
     * @param float $thirdPartyVatAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setThirdPartyVatAmount($thirdPartyVatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($thirdPartyVatAmount) && !(is_float($thirdPartyVatAmount) || is_numeric($thirdPartyVatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($thirdPartyVatAmount, true), gettype($thirdPartyVatAmount)), __LINE__);
        }
        $this->ThirdPartyVatAmount = $thirdPartyVatAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get ValidationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationErrors()
    {
        return isset($this->ValidationErrors) ? $this->ValidationErrors : null;
    }
    /**
     * Set ValidationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationErrors
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setValidationErrors($validationErrors = null)
    {
        // validation for constraint: string
        if (!is_null($validationErrors) && !is_string($validationErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationErrors, true), gettype($validationErrors)), __LINE__);
        }
        if (is_null($validationErrors) || (is_array($validationErrors) && empty($validationErrors))) {
            unset($this->ValidationErrors);
        } else {
            $this->ValidationErrors = $validationErrors;
        }
        return $this;
    }
    /**
     * Get VatAmount value
     * @return float|null
     */
    public function getVatAmount()
    {
        return $this->VatAmount;
    }
    /**
     * Set VatAmount value
     * @param float $vatAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setVatAmount($vatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vatAmount) && !(is_float($vatAmount) || is_numeric($vatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatAmount, true), gettype($vatAmount)), __LINE__);
        }
        $this->VatAmount = $vatAmount;
        return $this;
    }
    /**
     * Get EventDateDetailsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateDetailsText()
    {
        return isset($this->EventDateDetailsText) ? $this->EventDateDetailsText : null;
    }
    /**
     * Set EventDateDetailsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateDetailsText
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setEventDateDetailsText($eventDateDetailsText = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateDetailsText) && !is_string($eventDateDetailsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateDetailsText, true), gettype($eventDateDetailsText)), __LINE__);
        }
        if (is_null($eventDateDetailsText) || (is_array($eventDateDetailsText) && empty($eventDateDetailsText))) {
            unset($this->EventDateDetailsText);
        } else {
            $this->EventDateDetailsText = $eventDateDetailsText;
        }
        return $this;
    }
    /**
     * Get RegularPriceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRegularPriceAmount()
    {
        return isset($this->RegularPriceAmount) ? $this->RegularPriceAmount : null;
    }
    /**
     * Set RegularPriceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $regularPriceAmount
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setRegularPriceAmount($regularPriceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($regularPriceAmount) && !(is_float($regularPriceAmount) || is_numeric($regularPriceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($regularPriceAmount, true), gettype($regularPriceAmount)), __LINE__);
        }
        if (is_null($regularPriceAmount) || (is_array($regularPriceAmount) && empty($regularPriceAmount))) {
            unset($this->RegularPriceAmount);
        } else {
            $this->RegularPriceAmount = $regularPriceAmount;
        }
        return $this;
    }
    /**
     * Get IsInExchangeMode value
     * @return bool|null
     */
    public function getIsInExchangeMode()
    {
        return $this->IsInExchangeMode;
    }
    /**
     * Set IsInExchangeMode value
     * @param bool $isInExchangeMode
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setIsInExchangeMode($isInExchangeMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInExchangeMode) && !is_bool($isInExchangeMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInExchangeMode, true), gettype($isInExchangeMode)), __LINE__);
        }
        $this->IsInExchangeMode = $isInExchangeMode;
        return $this;
    }
    /**
     * Get IsRepriceMode value
     * @return bool|null
     */
    public function getIsRepriceMode()
    {
        return $this->IsRepriceMode;
    }
    /**
     * Set IsRepriceMode value
     * @param bool $isRepriceMode
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setIsRepriceMode($isRepriceMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRepriceMode) && !is_bool($isRepriceMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRepriceMode, true), gettype($isRepriceMode)), __LINE__);
        }
        $this->IsRepriceMode = $isRepriceMode;
        return $this;
    }
    /**
     * Get AccessCodeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeText()
    {
        return isset($this->AccessCodeText) ? $this->AccessCodeText : null;
    }
    /**
     * Set AccessCodeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeText
     * @return \patest\StructType\GroupedBasketNode
     */
    public function setAccessCodeText($accessCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeText) && !is_string($accessCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeText, true), gettype($accessCodeText)), __LINE__);
        }
        if (is_null($accessCodeText) || (is_array($accessCodeText) && empty($accessCodeText))) {
            unset($this->AccessCodeText);
        } else {
            $this->AccessCodeText = $accessCodeText;
        }
        return $this;
    }
}
