<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupCombination StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupCombination
 * @subpackage Structs
 */
class GroupCombination extends AbstractStructBase
{
    /**
     * The DiscountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscountType;
    /**
     * The DiscountValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DiscountValue;
    /**
     * The Participants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Participants;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * Constructor method for GroupCombination
     * @uses GroupCombination::setDiscountType()
     * @uses GroupCombination::setDiscountValue()
     * @uses GroupCombination::setParticipants()
     * @uses GroupCombination::setPriceTypeId()
     * @param string $discountType
     * @param float $discountValue
     * @param int $participants
     * @param string $priceTypeId
     */
    public function __construct($discountType = null, $discountValue = null, $participants = null, $priceTypeId = null)
    {
        $this
            ->setDiscountType($discountType)
            ->setDiscountValue($discountValue)
            ->setParticipants($participants)
            ->setPriceTypeId($priceTypeId);
    }
    /**
     * Get DiscountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscountType()
    {
        return isset($this->DiscountType) ? $this->DiscountType : null;
    }
    /**
     * Set DiscountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $discountType
     * @return \patest\StructType\GroupCombination
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($discountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($discountType) ? implode(', ', $discountType) : var_export($discountType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        if (is_null($discountType) || (is_array($discountType) && empty($discountType))) {
            unset($this->DiscountType);
        } else {
            $this->DiscountType = $discountType;
        }
        return $this;
    }
    /**
     * Get DiscountValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscountValue()
    {
        return isset($this->DiscountValue) ? $this->DiscountValue : null;
    }
    /**
     * Set DiscountValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discountValue
     * @return \patest\StructType\GroupCombination
     */
    public function setDiscountValue($discountValue = null)
    {
        // validation for constraint: float
        if (!is_null($discountValue) && !(is_float($discountValue) || is_numeric($discountValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountValue, true), gettype($discountValue)), __LINE__);
        }
        if (is_null($discountValue) || (is_array($discountValue) && empty($discountValue))) {
            unset($this->DiscountValue);
        } else {
            $this->DiscountValue = $discountValue;
        }
        return $this;
    }
    /**
     * Get Participants value
     * @return int|null
     */
    public function getParticipants()
    {
        return $this->Participants;
    }
    /**
     * Set Participants value
     * @param int $participants
     * @return \patest\StructType\GroupCombination
     */
    public function setParticipants($participants = null)
    {
        // validation for constraint: int
        if (!is_null($participants) && !(is_int($participants) || ctype_digit($participants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($participants, true), gettype($participants)), __LINE__);
        }
        $this->Participants = $participants;
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\GroupCombination
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
}
