<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.ProgramElement StructType
 * @subpackage Structs
 */
class GiftVoucher_ProgramElement extends GiftVoucher_PersistableEntityBase
{
    /**
     * The CardProgramId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardProgramId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PresetQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PresetQuantity;
    /**
     * The PricingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingMethod;
    /**
     * The PricingValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricingValue;
    /**
     * Constructor method for GiftVoucher.ProgramElement
     * @uses GiftVoucher_ProgramElement::setCardProgramId()
     * @uses GiftVoucher_ProgramElement::setName()
     * @uses GiftVoucher_ProgramElement::setPresetQuantity()
     * @uses GiftVoucher_ProgramElement::setPricingMethod()
     * @uses GiftVoucher_ProgramElement::setPricingValue()
     * @param string $cardProgramId
     * @param \patest\StructType\GlobalString $name
     * @param float $presetQuantity
     * @param string $pricingMethod
     * @param float $pricingValue
     */
    public function __construct($cardProgramId = null, \patest\StructType\GlobalString $name = null, $presetQuantity = null, $pricingMethod = null, $pricingValue = null)
    {
        $this
            ->setCardProgramId($cardProgramId)
            ->setName($name)
            ->setPresetQuantity($presetQuantity)
            ->setPricingMethod($pricingMethod)
            ->setPricingValue($pricingValue);
    }
    /**
     * Get CardProgramId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardProgramId()
    {
        return isset($this->CardProgramId) ? $this->CardProgramId : null;
    }
    /**
     * Set CardProgramId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardProgramId
     * @return \patest\StructType\GiftVoucher_ProgramElement
     */
    public function setCardProgramId($cardProgramId = null)
    {
        // validation for constraint: string
        if (!is_null($cardProgramId) && !is_string($cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProgramId, true), gettype($cardProgramId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardProgramId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardProgramId, true)), __LINE__);
        }
        if (is_null($cardProgramId) || (is_array($cardProgramId) && empty($cardProgramId))) {
            unset($this->CardProgramId);
        } else {
            $this->CardProgramId = $cardProgramId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\GiftVoucher_ProgramElement
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PresetQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPresetQuantity()
    {
        return isset($this->PresetQuantity) ? $this->PresetQuantity : null;
    }
    /**
     * Set PresetQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $presetQuantity
     * @return \patest\StructType\GiftVoucher_ProgramElement
     */
    public function setPresetQuantity($presetQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($presetQuantity) && !(is_float($presetQuantity) || is_numeric($presetQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($presetQuantity, true), gettype($presetQuantity)), __LINE__);
        }
        if (is_null($presetQuantity) || (is_array($presetQuantity) && empty($presetQuantity))) {
            unset($this->PresetQuantity);
        } else {
            $this->PresetQuantity = $presetQuantity;
        }
        return $this;
    }
    /**
     * Get PricingMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingMethod()
    {
        return isset($this->PricingMethod) ? $this->PricingMethod : null;
    }
    /**
     * Set PricingMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingMethod::valueIsValid()
     * @uses \patest\EnumType\PricingMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingMethod
     * @return \patest\StructType\GiftVoucher_ProgramElement
     */
    public function setPricingMethod($pricingMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingMethod::valueIsValid($pricingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingMethod', is_array($pricingMethod) ? implode(', ', $pricingMethod) : var_export($pricingMethod, true), implode(', ', \patest\EnumType\PricingMethod::getValidValues())), __LINE__);
        }
        if (is_null($pricingMethod) || (is_array($pricingMethod) && empty($pricingMethod))) {
            unset($this->PricingMethod);
        } else {
            $this->PricingMethod = $pricingMethod;
        }
        return $this;
    }
    /**
     * Get PricingValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricingValue()
    {
        return isset($this->PricingValue) ? $this->PricingValue : null;
    }
    /**
     * Set PricingValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricingValue
     * @return \patest\StructType\GiftVoucher_ProgramElement
     */
    public function setPricingValue($pricingValue = null)
    {
        // validation for constraint: float
        if (!is_null($pricingValue) && !(is_float($pricingValue) || is_numeric($pricingValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricingValue, true), gettype($pricingValue)), __LINE__);
        }
        if (is_null($pricingValue) || (is_array($pricingValue) && empty($pricingValue))) {
            unset($this->PricingValue);
        } else {
            $this->PricingValue = $pricingValue;
        }
        return $this;
    }
}
