<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.Coupon StructType
 * @subpackage Structs
 */
class GiftVoucher_Coupon extends DistributableEntity
{
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The IdentityType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityType;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LastRedemption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastRedemption;
    /**
     * The LastTransaction
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastTransaction;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The RedemptionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedemptionCount;
    /**
     * The RedemptionQuantity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedemptionQuantity;
    /**
     * The RedemptionQuantityPerTransaction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedemptionQuantityPerTransaction;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * Constructor method for GiftVoucher.Coupon
     * @uses GiftVoucher_Coupon::setDefinitionId()
     * @uses GiftVoucher_Coupon::setIdentityType()
     * @uses GiftVoucher_Coupon::setIsActive()
     * @uses GiftVoucher_Coupon::setLastRedemption()
     * @uses GiftVoucher_Coupon::setLastTransaction()
     * @uses GiftVoucher_Coupon::setName()
     * @uses GiftVoucher_Coupon::setNumber()
     * @uses GiftVoucher_Coupon::setRedemptionCount()
     * @uses GiftVoucher_Coupon::setRedemptionQuantity()
     * @uses GiftVoucher_Coupon::setRedemptionQuantityPerTransaction()
     * @uses GiftVoucher_Coupon::setSalesRepId()
     * @param string $definitionId
     * @param string $identityType
     * @param bool $isActive
     * @param string $lastRedemption
     * @param string $lastTransaction
     * @param \patest\StructType\GlobalString $name
     * @param string $number
     * @param int $redemptionCount
     * @param int $redemptionQuantity
     * @param int $redemptionQuantityPerTransaction
     * @param string $salesRepId
     */
    public function __construct($definitionId = null, $identityType = null, $isActive = null, $lastRedemption = null, $lastTransaction = null, \patest\StructType\GlobalString $name = null, $number = null, $redemptionCount = null, $redemptionQuantity = null, $redemptionQuantityPerTransaction = null, $salesRepId = null)
    {
        $this
            ->setDefinitionId($definitionId)
            ->setIdentityType($identityType)
            ->setIsActive($isActive)
            ->setLastRedemption($lastRedemption)
            ->setLastTransaction($lastTransaction)
            ->setName($name)
            ->setNumber($number)
            ->setRedemptionCount($redemptionCount)
            ->setRedemptionQuantity($redemptionQuantity)
            ->setRedemptionQuantityPerTransaction($redemptionQuantityPerTransaction)
            ->setSalesRepId($salesRepId);
    }
    /**
     * Get DefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionId()
    {
        return isset($this->DefinitionId) ? $this->DefinitionId : null;
    }
    /**
     * Set DefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionId
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        if (is_null($definitionId) || (is_array($definitionId) && empty($definitionId))) {
            unset($this->DefinitionId);
        } else {
            $this->DefinitionId = $definitionId;
        }
        return $this;
    }
    /**
     * Get IdentityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityType()
    {
        return isset($this->IdentityType) ? $this->IdentityType : null;
    }
    /**
     * Set IdentityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CouponIdentityType::valueIsValid()
     * @uses \patest\EnumType\CouponIdentityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identityType
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setIdentityType($identityType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CouponIdentityType::valueIsValid($identityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CouponIdentityType', is_array($identityType) ? implode(', ', $identityType) : var_export($identityType, true), implode(', ', \patest\EnumType\CouponIdentityType::getValidValues())), __LINE__);
        }
        if (is_null($identityType) || (is_array($identityType) && empty($identityType))) {
            unset($this->IdentityType);
        } else {
            $this->IdentityType = $identityType;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LastRedemption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastRedemption()
    {
        return isset($this->LastRedemption) ? $this->LastRedemption : null;
    }
    /**
     * Set LastRedemption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastRedemption
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setLastRedemption($lastRedemption = null)
    {
        // validation for constraint: string
        if (!is_null($lastRedemption) && !is_string($lastRedemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRedemption, true), gettype($lastRedemption)), __LINE__);
        }
        if (is_null($lastRedemption) || (is_array($lastRedemption) && empty($lastRedemption))) {
            unset($this->LastRedemption);
        } else {
            $this->LastRedemption = $lastRedemption;
        }
        return $this;
    }
    /**
     * Get LastTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTransaction()
    {
        return isset($this->LastTransaction) ? $this->LastTransaction : null;
    }
    /**
     * Set LastTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTransaction
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setLastTransaction($lastTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransaction) && !is_string($lastTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransaction, true), gettype($lastTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastTransaction, true)), __LINE__);
        }
        if (is_null($lastTransaction) || (is_array($lastTransaction) && empty($lastTransaction))) {
            unset($this->LastTransaction);
        } else {
            $this->LastTransaction = $lastTransaction;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get RedemptionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedemptionCount()
    {
        return isset($this->RedemptionCount) ? $this->RedemptionCount : null;
    }
    /**
     * Set RedemptionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redemptionCount
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setRedemptionCount($redemptionCount = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionCount) && !(is_int($redemptionCount) || ctype_digit($redemptionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionCount, true), gettype($redemptionCount)), __LINE__);
        }
        if (is_null($redemptionCount) || (is_array($redemptionCount) && empty($redemptionCount))) {
            unset($this->RedemptionCount);
        } else {
            $this->RedemptionCount = $redemptionCount;
        }
        return $this;
    }
    /**
     * Get RedemptionQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedemptionQuantity()
    {
        return isset($this->RedemptionQuantity) ? $this->RedemptionQuantity : null;
    }
    /**
     * Set RedemptionQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redemptionQuantity
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setRedemptionQuantity($redemptionQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantity) && !(is_int($redemptionQuantity) || ctype_digit($redemptionQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantity, true), gettype($redemptionQuantity)), __LINE__);
        }
        if (is_null($redemptionQuantity) || (is_array($redemptionQuantity) && empty($redemptionQuantity))) {
            unset($this->RedemptionQuantity);
        } else {
            $this->RedemptionQuantity = $redemptionQuantity;
        }
        return $this;
    }
    /**
     * Get RedemptionQuantityPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedemptionQuantityPerTransaction()
    {
        return isset($this->RedemptionQuantityPerTransaction) ? $this->RedemptionQuantityPerTransaction : null;
    }
    /**
     * Set RedemptionQuantityPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redemptionQuantityPerTransaction
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setRedemptionQuantityPerTransaction($redemptionQuantityPerTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantityPerTransaction) && !(is_int($redemptionQuantityPerTransaction) || ctype_digit($redemptionQuantityPerTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantityPerTransaction, true), gettype($redemptionQuantityPerTransaction)), __LINE__);
        }
        if (is_null($redemptionQuantityPerTransaction) || (is_array($redemptionQuantityPerTransaction) && empty($redemptionQuantityPerTransaction))) {
            unset($this->RedemptionQuantityPerTransaction);
        } else {
            $this->RedemptionQuantityPerTransaction = $redemptionQuantityPerTransaction;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\GiftVoucher_Coupon
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
}
