<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucherDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftVoucherDescription
 * @subpackage Structs
 */
class GiftVoucherDescription extends AbstractStructBase
{
    /**
     * The AvailableForDisplayFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayFrom;
    /**
     * The AvailableForDisplayUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayUntil;
    /**
     * The AvailableForSaleFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleFrom;
    /**
     * The AvailableForSaleUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleUntil;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExpiresInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExpiresInDays;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsClientMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsClientMessage;
    /**
     * The IsMultipleRedeemable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMultipleRedeemable;
    /**
     * The IsPrePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrePrinted;
    /**
     * The IssuerTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerTenantId;
    /**
     * The MaximumValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumValue;
    /**
     * The MinimumValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinimumValue;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Pricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GiftVoucherPricingDescription
     */
    public $Pricing;
    /**
     * The PricingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingOption;
    /**
     * The RedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RedemptionValue;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFrom;
    /**
     * The ValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidUntil;
    /**
     * Constructor method for GiftVoucherDescription
     * @uses GiftVoucherDescription::setAvailableForDisplayFrom()
     * @uses GiftVoucherDescription::setAvailableForDisplayUntil()
     * @uses GiftVoucherDescription::setAvailableForSaleFrom()
     * @uses GiftVoucherDescription::setAvailableForSaleUntil()
     * @uses GiftVoucherDescription::setDescription()
     * @uses GiftVoucherDescription::setExpiresInDays()
     * @uses GiftVoucherDescription::setGiftVoucherTypeId()
     * @uses GiftVoucherDescription::setId()
     * @uses GiftVoucherDescription::setIsActive()
     * @uses GiftVoucherDescription::setIsAvailableForDisplay()
     * @uses GiftVoucherDescription::setIsAvailableForSale()
     * @uses GiftVoucherDescription::setIsClientMessage()
     * @uses GiftVoucherDescription::setIsMultipleRedeemable()
     * @uses GiftVoucherDescription::setIsPrePrinted()
     * @uses GiftVoucherDescription::setIssuerTenantId()
     * @uses GiftVoucherDescription::setMaximumValue()
     * @uses GiftVoucherDescription::setMinimumValue()
     * @uses GiftVoucherDescription::setName()
     * @uses GiftVoucherDescription::setPricing()
     * @uses GiftVoucherDescription::setPricingOption()
     * @uses GiftVoucherDescription::setRedemptionValue()
     * @uses GiftVoucherDescription::setType()
     * @uses GiftVoucherDescription::setValidFrom()
     * @uses GiftVoucherDescription::setValidUntil()
     * @param string $availableForDisplayFrom
     * @param string $availableForDisplayUntil
     * @param string $availableForSaleFrom
     * @param string $availableForSaleUntil
     * @param string $description
     * @param int $expiresInDays
     * @param string $giftVoucherTypeId
     * @param string $id
     * @param bool $isActive
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param bool $isClientMessage
     * @param bool $isMultipleRedeemable
     * @param bool $isPrePrinted
     * @param int $issuerTenantId
     * @param float $maximumValue
     * @param float $minimumValue
     * @param string $name
     * @param \patest\StructType\GiftVoucherPricingDescription $pricing
     * @param string $pricingOption
     * @param float $redemptionValue
     * @param string $type
     * @param string $validFrom
     * @param string $validUntil
     */
    public function __construct($availableForDisplayFrom = null, $availableForDisplayUntil = null, $availableForSaleFrom = null, $availableForSaleUntil = null, $description = null, $expiresInDays = null, $giftVoucherTypeId = null, $id = null, $isActive = null, $isAvailableForDisplay = null, $isAvailableForSale = null, $isClientMessage = null, $isMultipleRedeemable = null, $isPrePrinted = null, $issuerTenantId = null, $maximumValue = null, $minimumValue = null, $name = null, \patest\StructType\GiftVoucherPricingDescription $pricing = null, $pricingOption = null, $redemptionValue = null, $type = null, $validFrom = null, $validUntil = null)
    {
        $this
            ->setAvailableForDisplayFrom($availableForDisplayFrom)
            ->setAvailableForDisplayUntil($availableForDisplayUntil)
            ->setAvailableForSaleFrom($availableForSaleFrom)
            ->setAvailableForSaleUntil($availableForSaleUntil)
            ->setDescription($description)
            ->setExpiresInDays($expiresInDays)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setId($id)
            ->setIsActive($isActive)
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsClientMessage($isClientMessage)
            ->setIsMultipleRedeemable($isMultipleRedeemable)
            ->setIsPrePrinted($isPrePrinted)
            ->setIssuerTenantId($issuerTenantId)
            ->setMaximumValue($maximumValue)
            ->setMinimumValue($minimumValue)
            ->setName($name)
            ->setPricing($pricing)
            ->setPricingOption($pricingOption)
            ->setRedemptionValue($redemptionValue)
            ->setType($type)
            ->setValidFrom($validFrom)
            ->setValidUntil($validUntil);
    }
    /**
     * Get AvailableForDisplayFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayFrom()
    {
        return isset($this->AvailableForDisplayFrom) ? $this->AvailableForDisplayFrom : null;
    }
    /**
     * Set AvailableForDisplayFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayFrom
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setAvailableForDisplayFrom($availableForDisplayFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayFrom) && !is_string($availableForDisplayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayFrom, true), gettype($availableForDisplayFrom)), __LINE__);
        }
        if (is_null($availableForDisplayFrom) || (is_array($availableForDisplayFrom) && empty($availableForDisplayFrom))) {
            unset($this->AvailableForDisplayFrom);
        } else {
            $this->AvailableForDisplayFrom = $availableForDisplayFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayUntil()
    {
        return isset($this->AvailableForDisplayUntil) ? $this->AvailableForDisplayUntil : null;
    }
    /**
     * Set AvailableForDisplayUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayUntil
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setAvailableForDisplayUntil($availableForDisplayUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayUntil) && !is_string($availableForDisplayUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayUntil, true), gettype($availableForDisplayUntil)), __LINE__);
        }
        if (is_null($availableForDisplayUntil) || (is_array($availableForDisplayUntil) && empty($availableForDisplayUntil))) {
            unset($this->AvailableForDisplayUntil);
        } else {
            $this->AvailableForDisplayUntil = $availableForDisplayUntil;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleFrom()
    {
        return isset($this->AvailableForSaleFrom) ? $this->AvailableForSaleFrom : null;
    }
    /**
     * Set AvailableForSaleFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleFrom
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setAvailableForSaleFrom($availableForSaleFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleFrom) && !is_string($availableForSaleFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleFrom, true), gettype($availableForSaleFrom)), __LINE__);
        }
        if (is_null($availableForSaleFrom) || (is_array($availableForSaleFrom) && empty($availableForSaleFrom))) {
            unset($this->AvailableForSaleFrom);
        } else {
            $this->AvailableForSaleFrom = $availableForSaleFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleUntil()
    {
        return isset($this->AvailableForSaleUntil) ? $this->AvailableForSaleUntil : null;
    }
    /**
     * Set AvailableForSaleUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleUntil
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setAvailableForSaleUntil($availableForSaleUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleUntil) && !is_string($availableForSaleUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleUntil, true), gettype($availableForSaleUntil)), __LINE__);
        }
        if (is_null($availableForSaleUntil) || (is_array($availableForSaleUntil) && empty($availableForSaleUntil))) {
            unset($this->AvailableForSaleUntil);
        } else {
            $this->AvailableForSaleUntil = $availableForSaleUntil;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpiresInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpiresInDays()
    {
        return isset($this->ExpiresInDays) ? $this->ExpiresInDays : null;
    }
    /**
     * Set ExpiresInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expiresInDays
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setExpiresInDays($expiresInDays = null)
    {
        // validation for constraint: int
        if (!is_null($expiresInDays) && !(is_int($expiresInDays) || ctype_digit($expiresInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiresInDays, true), gettype($expiresInDays)), __LINE__);
        }
        if (is_null($expiresInDays) || (is_array($expiresInDays) && empty($expiresInDays))) {
            unset($this->ExpiresInDays);
        } else {
            $this->ExpiresInDays = $expiresInDays;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return $this->GiftVoucherTypeId;
    }
    /**
     * Set GiftVoucherTypeId value
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        $this->GiftVoucherTypeId = $giftVoucherTypeId;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsAvailableForDisplay value
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return $this->IsAvailableForDisplay;
    }
    /**
     * Set IsAvailableForDisplay value
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        $this->IsAvailableForDisplay = $isAvailableForDisplay;
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return $this->IsAvailableForSale;
    }
    /**
     * Set IsAvailableForSale value
     * @param bool $isAvailableForSale
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        $this->IsAvailableForSale = $isAvailableForSale;
        return $this;
    }
    /**
     * Get IsClientMessage value
     * @return bool|null
     */
    public function getIsClientMessage()
    {
        return $this->IsClientMessage;
    }
    /**
     * Set IsClientMessage value
     * @param bool $isClientMessage
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIsClientMessage($isClientMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClientMessage) && !is_bool($isClientMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClientMessage, true), gettype($isClientMessage)), __LINE__);
        }
        $this->IsClientMessage = $isClientMessage;
        return $this;
    }
    /**
     * Get IsMultipleRedeemable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMultipleRedeemable()
    {
        return isset($this->IsMultipleRedeemable) ? $this->IsMultipleRedeemable : null;
    }
    /**
     * Set IsMultipleRedeemable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMultipleRedeemable
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIsMultipleRedeemable($isMultipleRedeemable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultipleRedeemable) && !is_bool($isMultipleRedeemable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMultipleRedeemable, true), gettype($isMultipleRedeemable)), __LINE__);
        }
        if (is_null($isMultipleRedeemable) || (is_array($isMultipleRedeemable) && empty($isMultipleRedeemable))) {
            unset($this->IsMultipleRedeemable);
        } else {
            $this->IsMultipleRedeemable = $isMultipleRedeemable;
        }
        return $this;
    }
    /**
     * Get IsPrePrinted value
     * @return bool|null
     */
    public function getIsPrePrinted()
    {
        return $this->IsPrePrinted;
    }
    /**
     * Set IsPrePrinted value
     * @param bool $isPrePrinted
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIsPrePrinted($isPrePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrePrinted) && !is_bool($isPrePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrePrinted, true), gettype($isPrePrinted)), __LINE__);
        }
        $this->IsPrePrinted = $isPrePrinted;
        return $this;
    }
    /**
     * Get IssuerTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerTenantId()
    {
        return isset($this->IssuerTenantId) ? $this->IssuerTenantId : null;
    }
    /**
     * Set IssuerTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerTenantId
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setIssuerTenantId($issuerTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTenantId) && !(is_int($issuerTenantId) || ctype_digit($issuerTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTenantId, true), gettype($issuerTenantId)), __LINE__);
        }
        if (is_null($issuerTenantId) || (is_array($issuerTenantId) && empty($issuerTenantId))) {
            unset($this->IssuerTenantId);
        } else {
            $this->IssuerTenantId = $issuerTenantId;
        }
        return $this;
    }
    /**
     * Get MaximumValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumValue()
    {
        return isset($this->MaximumValue) ? $this->MaximumValue : null;
    }
    /**
     * Set MaximumValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumValue
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setMaximumValue($maximumValue = null)
    {
        // validation for constraint: float
        if (!is_null($maximumValue) && !(is_float($maximumValue) || is_numeric($maximumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumValue, true), gettype($maximumValue)), __LINE__);
        }
        if (is_null($maximumValue) || (is_array($maximumValue) && empty($maximumValue))) {
            unset($this->MaximumValue);
        } else {
            $this->MaximumValue = $maximumValue;
        }
        return $this;
    }
    /**
     * Get MinimumValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinimumValue()
    {
        return isset($this->MinimumValue) ? $this->MinimumValue : null;
    }
    /**
     * Set MinimumValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minimumValue
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setMinimumValue($minimumValue = null)
    {
        // validation for constraint: float
        if (!is_null($minimumValue) && !(is_float($minimumValue) || is_numeric($minimumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumValue, true), gettype($minimumValue)), __LINE__);
        }
        if (is_null($minimumValue) || (is_array($minimumValue) && empty($minimumValue))) {
            unset($this->MinimumValue);
        } else {
            $this->MinimumValue = $minimumValue;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Pricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GiftVoucherPricingDescription|null
     */
    public function getPricing()
    {
        return isset($this->Pricing) ? $this->Pricing : null;
    }
    /**
     * Set Pricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GiftVoucherPricingDescription $pricing
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setPricing(\patest\StructType\GiftVoucherPricingDescription $pricing = null)
    {
        if (is_null($pricing) || (is_array($pricing) && empty($pricing))) {
            unset($this->Pricing);
        } else {
            $this->Pricing = $pricing;
        }
        return $this;
    }
    /**
     * Get PricingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingOption()
    {
        return isset($this->PricingOption) ? $this->PricingOption : null;
    }
    /**
     * Set PricingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingOption::valueIsValid()
     * @uses \patest\EnumType\PricingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingOption
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setPricingOption($pricingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingOption::valueIsValid($pricingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingOption', is_array($pricingOption) ? implode(', ', $pricingOption) : var_export($pricingOption, true), implode(', ', \patest\EnumType\PricingOption::getValidValues())), __LINE__);
        }
        if (is_null($pricingOption) || (is_array($pricingOption) && empty($pricingOption))) {
            unset($this->PricingOption);
        } else {
            $this->PricingOption = $pricingOption;
        }
        return $this;
    }
    /**
     * Get RedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRedemptionValue()
    {
        return isset($this->RedemptionValue) ? $this->RedemptionValue : null;
    }
    /**
     * Set RedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $redemptionValue
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setRedemptionValue($redemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($redemptionValue) && !(is_float($redemptionValue) || is_numeric($redemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redemptionValue, true), gettype($redemptionValue)), __LINE__);
        }
        if (is_null($redemptionValue) || (is_array($redemptionValue) && empty($redemptionValue))) {
            unset($this->RedemptionValue);
        } else {
            $this->RedemptionValue = $redemptionValue;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\GiftVoucherType::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\GiftVoucherType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFrom()
    {
        return isset($this->ValidFrom) ? $this->ValidFrom : null;
    }
    /**
     * Set ValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFrom
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        if (is_null($validFrom) || (is_array($validFrom) && empty($validFrom))) {
            unset($this->ValidFrom);
        } else {
            $this->ValidFrom = $validFrom;
        }
        return $this;
    }
    /**
     * Get ValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidUntil()
    {
        return isset($this->ValidUntil) ? $this->ValidUntil : null;
    }
    /**
     * Set ValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validUntil
     * @return \patest\StructType\GiftVoucherDescription
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        if (is_null($validUntil) || (is_array($validUntil) && empty($validUntil))) {
            unset($this->ValidUntil);
        } else {
            $this->ValidUntil = $validUntil;
        }
        return $this;
    }
}
