<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCardPaymentDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftCardPaymentDescription
 * @subpackage Structs
 */
class GiftCardPaymentDescription extends AbstractPaymentDescription
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardProgramId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardProgramId;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * Constructor method for GiftCardPaymentDescription
     * @uses GiftCardPaymentDescription::setCardNumber()
     * @uses GiftCardPaymentDescription::setCardProgramId()
     * @uses GiftCardPaymentDescription::setCardTypeId()
     * @param string $cardNumber
     * @param string $cardProgramId
     * @param string $cardTypeId
     */
    public function __construct($cardNumber = null, $cardProgramId = null, $cardTypeId = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardProgramId($cardProgramId)
            ->setCardTypeId($cardTypeId);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\GiftCardPaymentDescription
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardProgramId value
     * @return string|null
     */
    public function getCardProgramId()
    {
        return $this->CardProgramId;
    }
    /**
     * Set CardProgramId value
     * @param string $cardProgramId
     * @return \patest\StructType\GiftCardPaymentDescription
     */
    public function setCardProgramId($cardProgramId = null)
    {
        // validation for constraint: string
        if (!is_null($cardProgramId) && !is_string($cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProgramId, true), gettype($cardProgramId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardProgramId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardProgramId, true)), __LINE__);
        }
        $this->CardProgramId = $cardProgramId;
        return $this;
    }
    /**
     * Get CardTypeId value
     * @return string|null
     */
    public function getCardTypeId()
    {
        return $this->CardTypeId;
    }
    /**
     * Set CardTypeId value
     * @param string $cardTypeId
     * @return \patest\StructType\GiftCardPaymentDescription
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        $this->CardTypeId = $cardTypeId;
        return $this;
    }
}
