<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUpdatedEntitiesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUpdatedEntitiesRequest
 * @subpackage Structs
 */
class GetUpdatedEntitiesRequest extends AbstractStructBase
{
    /**
     * The ChunkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChunkSize;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The InitialSyncMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $InitialSyncMode;
    /**
     * The ManualMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ManualMode;
    /**
     * The PreviousWatermark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviousWatermark;
    /**
     * The SpecificIdProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificIdProperty;
    /**
     * The SpecificIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificIds;
    /**
     * The SroIdsToAvoid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SroIdsToAvoid;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $To;
    /**
     * Constructor method for GetUpdatedEntitiesRequest
     * @uses GetUpdatedEntitiesRequest::setChunkSize()
     * @uses GetUpdatedEntitiesRequest::setEntityName()
     * @uses GetUpdatedEntitiesRequest::setFrom()
     * @uses GetUpdatedEntitiesRequest::setInitialSyncMode()
     * @uses GetUpdatedEntitiesRequest::setManualMode()
     * @uses GetUpdatedEntitiesRequest::setPreviousWatermark()
     * @uses GetUpdatedEntitiesRequest::setSpecificIdProperty()
     * @uses GetUpdatedEntitiesRequest::setSpecificIds()
     * @uses GetUpdatedEntitiesRequest::setSroIdsToAvoid()
     * @uses GetUpdatedEntitiesRequest::setTo()
     * @param int $chunkSize
     * @param string $entityName
     * @param string $from
     * @param bool $initialSyncMode
     * @param bool $manualMode
     * @param string $previousWatermark
     * @param string $specificIdProperty
     * @param string $specificIds
     * @param \patest\ArrayType\ArrayOfguid $sroIdsToAvoid
     * @param string $to
     */
    public function __construct($chunkSize = null, $entityName = null, $from = null, $initialSyncMode = null, $manualMode = null, $previousWatermark = null, $specificIdProperty = null, $specificIds = null, \patest\ArrayType\ArrayOfguid $sroIdsToAvoid = null, $to = null)
    {
        $this
            ->setChunkSize($chunkSize)
            ->setEntityName($entityName)
            ->setFrom($from)
            ->setInitialSyncMode($initialSyncMode)
            ->setManualMode($manualMode)
            ->setPreviousWatermark($previousWatermark)
            ->setSpecificIdProperty($specificIdProperty)
            ->setSpecificIds($specificIds)
            ->setSroIdsToAvoid($sroIdsToAvoid)
            ->setTo($to);
    }
    /**
     * Get ChunkSize value
     * @return int|null
     */
    public function getChunkSize()
    {
        return $this->ChunkSize;
    }
    /**
     * Set ChunkSize value
     * @param int $chunkSize
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setChunkSize($chunkSize = null)
    {
        // validation for constraint: int
        if (!is_null($chunkSize) && !(is_int($chunkSize) || ctype_digit($chunkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chunkSize, true), gettype($chunkSize)), __LINE__);
        }
        $this->ChunkSize = $chunkSize;
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get InitialSyncMode value
     * @return bool|null
     */
    public function getInitialSyncMode()
    {
        return $this->InitialSyncMode;
    }
    /**
     * Set InitialSyncMode value
     * @param bool $initialSyncMode
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setInitialSyncMode($initialSyncMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($initialSyncMode) && !is_bool($initialSyncMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($initialSyncMode, true), gettype($initialSyncMode)), __LINE__);
        }
        $this->InitialSyncMode = $initialSyncMode;
        return $this;
    }
    /**
     * Get ManualMode value
     * @return bool|null
     */
    public function getManualMode()
    {
        return $this->ManualMode;
    }
    /**
     * Set ManualMode value
     * @param bool $manualMode
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setManualMode($manualMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($manualMode) && !is_bool($manualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manualMode, true), gettype($manualMode)), __LINE__);
        }
        $this->ManualMode = $manualMode;
        return $this;
    }
    /**
     * Get PreviousWatermark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousWatermark()
    {
        return isset($this->PreviousWatermark) ? $this->PreviousWatermark : null;
    }
    /**
     * Set PreviousWatermark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousWatermark
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setPreviousWatermark($previousWatermark = null)
    {
        // validation for constraint: string
        if (!is_null($previousWatermark) && !is_string($previousWatermark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousWatermark, true), gettype($previousWatermark)), __LINE__);
        }
        if (is_null($previousWatermark) || (is_array($previousWatermark) && empty($previousWatermark))) {
            unset($this->PreviousWatermark);
        } else {
            $this->PreviousWatermark = $previousWatermark;
        }
        return $this;
    }
    /**
     * Get SpecificIdProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificIdProperty()
    {
        return isset($this->SpecificIdProperty) ? $this->SpecificIdProperty : null;
    }
    /**
     * Set SpecificIdProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificIdProperty
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setSpecificIdProperty($specificIdProperty = null)
    {
        // validation for constraint: string
        if (!is_null($specificIdProperty) && !is_string($specificIdProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificIdProperty, true), gettype($specificIdProperty)), __LINE__);
        }
        if (is_null($specificIdProperty) || (is_array($specificIdProperty) && empty($specificIdProperty))) {
            unset($this->SpecificIdProperty);
        } else {
            $this->SpecificIdProperty = $specificIdProperty;
        }
        return $this;
    }
    /**
     * Get SpecificIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificIds()
    {
        return isset($this->SpecificIds) ? $this->SpecificIds : null;
    }
    /**
     * Set SpecificIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificIds
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setSpecificIds($specificIds = null)
    {
        // validation for constraint: string
        if (!is_null($specificIds) && !is_string($specificIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificIds, true), gettype($specificIds)), __LINE__);
        }
        if (is_null($specificIds) || (is_array($specificIds) && empty($specificIds))) {
            unset($this->SpecificIds);
        } else {
            $this->SpecificIds = $specificIds;
        }
        return $this;
    }
    /**
     * Get SroIdsToAvoid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSroIdsToAvoid()
    {
        return isset($this->SroIdsToAvoid) ? $this->SroIdsToAvoid : null;
    }
    /**
     * Set SroIdsToAvoid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $sroIdsToAvoid
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setSroIdsToAvoid(\patest\ArrayType\ArrayOfguid $sroIdsToAvoid = null)
    {
        if (is_null($sroIdsToAvoid) || (is_array($sroIdsToAvoid) && empty($sroIdsToAvoid))) {
            unset($this->SroIdsToAvoid);
        } else {
            $this->SroIdsToAvoid = $sroIdsToAvoid;
        }
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \patest\StructType\GetUpdatedEntitiesRequest
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
}
