<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionPrintedPdfDocumentsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTransactionPrintedPdfDocumentsResponse
 * @subpackage Structs
 */
class GetTransactionPrintedPdfDocumentsResponse extends AbstractStructBase
{
    /**
     * The IsComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsComplete;
    /**
     * The PrintableItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAnyEntity
     */
    public $PrintableItems;
    /**
     * The RenderedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenderedDocument;
    /**
     * Constructor method for GetTransactionPrintedPdfDocumentsResponse
     * @uses GetTransactionPrintedPdfDocumentsResponse::setIsComplete()
     * @uses GetTransactionPrintedPdfDocumentsResponse::setPrintableItems()
     * @uses GetTransactionPrintedPdfDocumentsResponse::setRenderedDocument()
     * @param bool $isComplete
     * @param \patest\ArrayType\ArrayOfAnyEntity $printableItems
     * @param string $renderedDocument
     */
    public function __construct($isComplete = null, \patest\ArrayType\ArrayOfAnyEntity $printableItems = null, $renderedDocument = null)
    {
        $this
            ->setIsComplete($isComplete)
            ->setPrintableItems($printableItems)
            ->setRenderedDocument($renderedDocument);
    }
    /**
     * Get IsComplete value
     * @return bool|null
     */
    public function getIsComplete()
    {
        return $this->IsComplete;
    }
    /**
     * Set IsComplete value
     * @param bool $isComplete
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsResponse
     */
    public function setIsComplete($isComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplete) && !is_bool($isComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplete, true), gettype($isComplete)), __LINE__);
        }
        $this->IsComplete = $isComplete;
        return $this;
    }
    /**
     * Get PrintableItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAnyEntity|null
     */
    public function getPrintableItems()
    {
        return isset($this->PrintableItems) ? $this->PrintableItems : null;
    }
    /**
     * Set PrintableItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAnyEntity $printableItems
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsResponse
     */
    public function setPrintableItems(\patest\ArrayType\ArrayOfAnyEntity $printableItems = null)
    {
        if (is_null($printableItems) || (is_array($printableItems) && empty($printableItems))) {
            unset($this->PrintableItems);
        } else {
            $this->PrintableItems = $printableItems;
        }
        return $this;
    }
    /**
     * Get RenderedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenderedDocument()
    {
        return isset($this->RenderedDocument) ? $this->RenderedDocument : null;
    }
    /**
     * Set RenderedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renderedDocument
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsResponse
     */
    public function setRenderedDocument($renderedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($renderedDocument) && !is_string($renderedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renderedDocument, true), gettype($renderedDocument)), __LINE__);
        }
        if (is_null($renderedDocument) || (is_array($renderedDocument) && empty($renderedDocument))) {
            unset($this->RenderedDocument);
        } else {
            $this->RenderedDocument = $renderedDocument;
        }
        return $this;
    }
}
