<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionPrintedPdfDocumentsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTransactionPrintedPdfDocumentsRequest
 * @subpackage Structs
 */
class GetTransactionPrintedPdfDocumentsRequest extends AbstractStructBase
{
    /**
     * The NeedRawData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NeedRawData;
    /**
     * The SpoolGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpoolGroupId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for GetTransactionPrintedPdfDocumentsRequest
     * @uses GetTransactionPrintedPdfDocumentsRequest::setNeedRawData()
     * @uses GetTransactionPrintedPdfDocumentsRequest::setSpoolGroupId()
     * @uses GetTransactionPrintedPdfDocumentsRequest::setTransactionId()
     * @param bool $needRawData
     * @param string $spoolGroupId
     * @param string $transactionId
     */
    public function __construct($needRawData = null, $spoolGroupId = null, $transactionId = null)
    {
        $this
            ->setNeedRawData($needRawData)
            ->setSpoolGroupId($spoolGroupId)
            ->setTransactionId($transactionId);
    }
    /**
     * Get NeedRawData value
     * @return bool|null
     */
    public function getNeedRawData()
    {
        return $this->NeedRawData;
    }
    /**
     * Set NeedRawData value
     * @param bool $needRawData
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsRequest
     */
    public function setNeedRawData($needRawData = null)
    {
        // validation for constraint: boolean
        if (!is_null($needRawData) && !is_bool($needRawData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needRawData, true), gettype($needRawData)), __LINE__);
        }
        $this->NeedRawData = $needRawData;
        return $this;
    }
    /**
     * Get SpoolGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoolGroupId()
    {
        return isset($this->SpoolGroupId) ? $this->SpoolGroupId : null;
    }
    /**
     * Set SpoolGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoolGroupId
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsRequest
     */
    public function setSpoolGroupId($spoolGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($spoolGroupId) && !is_string($spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolGroupId, true), gettype($spoolGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($spoolGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($spoolGroupId, true)), __LINE__);
        }
        if (is_null($spoolGroupId) || (is_array($spoolGroupId) && empty($spoolGroupId))) {
            unset($this->SpoolGroupId);
        } else {
            $this->SpoolGroupId = $spoolGroupId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
