<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShowDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetShowDescription-Request
 * @subpackage Structs
 */
class GetShowDescription_Request extends ExtensibleDataContract
{
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * Constructor method for GetShowDescription-Request
     * @uses GetShowDescription_Request::setShowId()
     * @uses GetShowDescription_Request::setCouponIdentity()
     * @param string $showId
     * @param \patest\StructType\CouponIdentity $couponIdentity
     */
    public function __construct($showId = null, \patest\StructType\CouponIdentity $couponIdentity = null)
    {
        $this
            ->setShowId($showId)
            ->setCouponIdentity($couponIdentity);
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\GetShowDescription_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\GetShowDescription_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
}
