<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSchemeDescription-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSchemeDescription-Response
 * @subpackage Structs
 */
class GetSchemeDescription_Response extends ExtensibleDataContract
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SchemeDescription
     */
    public $Description;
    /**
     * Constructor method for GetSchemeDescription-Response
     * @uses GetSchemeDescription_Response::setDescription()
     * @param \patest\StructType\SchemeDescription $description
     */
    public function __construct(\patest\StructType\SchemeDescription $description = null)
    {
        $this
            ->setDescription($description);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SchemeDescription|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SchemeDescription $description
     * @return \patest\StructType\GetSchemeDescription_Response
     */
    public function setDescription(\patest\StructType\SchemeDescription $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
