<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPrompts-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPrompts-Request
 * @subpackage Structs
 */
class GetPrompts_Request extends ExtensibleDataContract
{
    /**
     * The SubTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SubTypes;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for GetPrompts-Request
     * @uses GetPrompts_Request::setSubTypes()
     * @uses GetPrompts_Request::setTransactionGuid()
     * @param string[] $subTypes
     * @param string $transactionGuid
     */
    public function __construct(array $subTypes = array(), $transactionGuid = null)
    {
        $this
            ->setSubTypes($subTypes)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get SubTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSubTypes()
    {
        return isset($this->SubTypes) ? $this->SubTypes : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubTypesForArrayConstraintsFromSetSubTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPrompts_RequestSubTypesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PromptSubTypes::valueIsValid($getPrompts_RequestSubTypesItem)) {
                $invalidValues[] = is_object($getPrompts_RequestSubTypesItem) ? get_class($getPrompts_RequestSubTypesItem) : sprintf('%s(%s)', gettype($getPrompts_RequestSubTypesItem), var_export($getPrompts_RequestSubTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PromptSubTypes', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PromptSubTypes::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PromptSubTypes::valueIsValid()
     * @uses \patest\EnumType\PromptSubTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $subTypes
     * @return \patest\StructType\GetPrompts_Request
     */
    public function setSubTypes(array $subTypes = array())
    {
        // validation for constraint: list
        if ('' !== ($subTypesArrayErrorMessage = self::validateSubTypesForArrayConstraintsFromSetSubTypes($subTypes))) {
            throw new \InvalidArgumentException($subTypesArrayErrorMessage, __LINE__);
        }
        if (is_null($subTypes) || (is_array($subTypes) && empty($subTypes))) {
            unset($this->SubTypes);
        } else {
            $this->SubTypes = is_array($subTypes) ? implode(' ', $subTypes) : null;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\GetPrompts_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
