<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetProductDescription-Request
 * @subpackage Structs
 */
class GetProductDescription_Request extends ExtensibleDataContract
{
    /**
     * The IncludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePricing;
    /**
     * The IncludeStockState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeStockState;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * Constructor method for GetProductDescription-Request
     * @uses GetProductDescription_Request::setIncludePricing()
     * @uses GetProductDescription_Request::setIncludeStockState()
     * @uses GetProductDescription_Request::setProductId()
     * @param bool $includePricing
     * @param bool $includeStockState
     * @param string $productId
     */
    public function __construct($includePricing = null, $includeStockState = null, $productId = null)
    {
        $this
            ->setIncludePricing($includePricing)
            ->setIncludeStockState($includeStockState)
            ->setProductId($productId);
    }
    /**
     * Get IncludePricing value
     * @return bool|null
     */
    public function getIncludePricing()
    {
        return $this->IncludePricing;
    }
    /**
     * Set IncludePricing value
     * @param bool $includePricing
     * @return \patest\StructType\GetProductDescription_Request
     */
    public function setIncludePricing($includePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePricing) && !is_bool($includePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePricing, true), gettype($includePricing)), __LINE__);
        }
        $this->IncludePricing = $includePricing;
        return $this;
    }
    /**
     * Get IncludeStockState value
     * @return bool|null
     */
    public function getIncludeStockState()
    {
        return $this->IncludeStockState;
    }
    /**
     * Set IncludeStockState value
     * @param bool $includeStockState
     * @return \patest\StructType\GetProductDescription_Request
     */
    public function setIncludeStockState($includeStockState = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeStockState) && !is_bool($includeStockState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeStockState, true), gettype($includeStockState)), __LINE__);
        }
        $this->IncludeStockState = $includeStockState;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \patest\StructType\GetProductDescription_Request
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
}
