<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductDescriptionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetProductDescriptionRequest
 * @subpackage Structs
 */
class GetProductDescriptionRequest extends ExtensibleDataContract
{
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The DescriptionLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $DescriptionLevel;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The IncludeBasketLevelPriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeBasketLevelPriceModifiers;
    /**
     * Constructor method for GetProductDescriptionRequest
     * @uses GetProductDescriptionRequest::setCouponDefinitionId()
     * @uses GetProductDescriptionRequest::setDescriptionLevel()
     * @uses GetProductDescriptionRequest::setProductId()
     * @uses GetProductDescriptionRequest::setProductType()
     * @uses GetProductDescriptionRequest::setIncludeBasketLevelPriceModifiers()
     * @param string $couponDefinitionId
     * @param string[] $descriptionLevel
     * @param string $productId
     * @param string $productType
     * @param bool $includeBasketLevelPriceModifiers
     */
    public function __construct($couponDefinitionId = null, array $descriptionLevel = array(), $productId = null, $productType = null, $includeBasketLevelPriceModifiers = null)
    {
        $this
            ->setCouponDefinitionId($couponDefinitionId)
            ->setDescriptionLevel($descriptionLevel)
            ->setProductId($productId)
            ->setProductType($productType)
            ->setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers);
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\GetProductDescriptionRequest
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get DescriptionLevel value
     * @return string[]|null
     */
    public function getDescriptionLevel()
    {
        return $this->DescriptionLevel;
    }
    /**
     * This method is responsible for validating the values passed to the setDescriptionLevel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescriptionLevel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionLevelForArrayConstraintsFromSetDescriptionLevel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getProductDescriptionRequestDescriptionLevelItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\ProductDescriptionLevel::valueIsValid($getProductDescriptionRequestDescriptionLevelItem)) {
                $invalidValues[] = is_object($getProductDescriptionRequestDescriptionLevelItem) ? get_class($getProductDescriptionRequestDescriptionLevelItem) : sprintf('%s(%s)', gettype($getProductDescriptionRequestDescriptionLevelItem), var_export($getProductDescriptionRequestDescriptionLevelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductDescriptionLevel', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\ProductDescriptionLevel::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DescriptionLevel value
     * @uses \patest\EnumType\ProductDescriptionLevel::valueIsValid()
     * @uses \patest\EnumType\ProductDescriptionLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $descriptionLevel
     * @return \patest\StructType\GetProductDescriptionRequest
     */
    public function setDescriptionLevel(array $descriptionLevel = array())
    {
        // validation for constraint: list
        if ('' !== ($descriptionLevelArrayErrorMessage = self::validateDescriptionLevelForArrayConstraintsFromSetDescriptionLevel($descriptionLevel))) {
            throw new \InvalidArgumentException($descriptionLevelArrayErrorMessage, __LINE__);
        }
        $this->DescriptionLevel = is_array($descriptionLevel) ? implode(' ', $descriptionLevel) : null;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \patest\StructType\GetProductDescriptionRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productType
     * @return \patest\StructType\GetProductDescriptionRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get IncludeBasketLevelPriceModifiers value
     * @return bool|null
     */
    public function getIncludeBasketLevelPriceModifiers()
    {
        return $this->IncludeBasketLevelPriceModifiers;
    }
    /**
     * Set IncludeBasketLevelPriceModifiers value
     * @param bool $includeBasketLevelPriceModifiers
     * @return \patest\StructType\GetProductDescriptionRequest
     */
    public function setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBasketLevelPriceModifiers) && !is_bool($includeBasketLevelPriceModifiers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBasketLevelPriceModifiers, true), gettype($includeBasketLevelPriceModifiers)), __LINE__);
        }
        $this->IncludeBasketLevelPriceModifiers = $includeBasketLevelPriceModifiers;
        return $this;
    }
}
