<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductDescriptionOfCardLoadingResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetProductDescriptionOfCardLoadingResponse
 * @subpackage Structs
 */
class GetProductDescriptionOfCardLoadingResponse extends AbstractStructBase
{
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The PricingDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProductPricingDescription
     */
    public $PricingDescription;
    /**
     * The ProductDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public $ProductDescription;
    /**
     * Constructor method for GetProductDescriptionOfCardLoadingResponse
     * @uses GetProductDescriptionOfCardLoadingResponse::setIsAvailableForDisplay()
     * @uses GetProductDescriptionOfCardLoadingResponse::setIsAvailableForSale()
     * @uses GetProductDescriptionOfCardLoadingResponse::setPricingDescription()
     * @uses GetProductDescriptionOfCardLoadingResponse::setProductDescription()
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param \patest\StructType\ProductPricingDescription $pricingDescription
     * @param \patest\StructType\GiftVoucher_CardLoadingProductDescription $productDescription
     */
    public function __construct($isAvailableForDisplay = null, $isAvailableForSale = null, \patest\StructType\ProductPricingDescription $pricingDescription = null, \patest\StructType\GiftVoucher_CardLoadingProductDescription $productDescription = null)
    {
        $this
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setPricingDescription($pricingDescription)
            ->setProductDescription($productDescription);
    }
    /**
     * Get IsAvailableForDisplay value
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return $this->IsAvailableForDisplay;
    }
    /**
     * Set IsAvailableForDisplay value
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\GetProductDescriptionOfCardLoadingResponse
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        $this->IsAvailableForDisplay = $isAvailableForDisplay;
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return $this->IsAvailableForSale;
    }
    /**
     * Set IsAvailableForSale value
     * @param bool $isAvailableForSale
     * @return \patest\StructType\GetProductDescriptionOfCardLoadingResponse
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        $this->IsAvailableForSale = $isAvailableForSale;
        return $this;
    }
    /**
     * Get PricingDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProductPricingDescription|null
     */
    public function getPricingDescription()
    {
        return isset($this->PricingDescription) ? $this->PricingDescription : null;
    }
    /**
     * Set PricingDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProductPricingDescription $pricingDescription
     * @return \patest\StructType\GetProductDescriptionOfCardLoadingResponse
     */
    public function setPricingDescription(\patest\StructType\ProductPricingDescription $pricingDescription = null)
    {
        if (is_null($pricingDescription) || (is_array($pricingDescription) && empty($pricingDescription))) {
            unset($this->PricingDescription);
        } else {
            $this->PricingDescription = $pricingDescription;
        }
        return $this;
    }
    /**
     * Get ProductDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription|null
     */
    public function getProductDescription()
    {
        return isset($this->ProductDescription) ? $this->ProductDescription : null;
    }
    /**
     * Set ProductDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GiftVoucher_CardLoadingProductDescription $productDescription
     * @return \patest\StructType\GetProductDescriptionOfCardLoadingResponse
     */
    public function setProductDescription(\patest\StructType\GiftVoucher_CardLoadingProductDescription $productDescription = null)
    {
        if (is_null($productDescription) || (is_array($productDescription) && empty($productDescription))) {
            unset($this->ProductDescription);
        } else {
            $this->ProductDescription = $productDescription;
        }
        return $this;
    }
}
