<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPresales-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPresales-Request
 * @subpackage Structs
 */
class GetPresales_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IncludeAccessCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeAccessCodes;
    /**
     * The IncludeAccessCodesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeAccessCodesCount;
    /**
     * The IncludeAccessCodesTransactionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeAccessCodesTransactionCount;
    /**
     * The IncludeInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeInactive;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The PresaleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PresaleName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for GetPresales-Request
     * @uses GetPresales_Request::setEventId()
     * @uses GetPresales_Request::setIncludeAccessCodes()
     * @uses GetPresales_Request::setIncludeAccessCodesCount()
     * @uses GetPresales_Request::setIncludeAccessCodesTransactionCount()
     * @uses GetPresales_Request::setIncludeInactive()
     * @uses GetPresales_Request::setPresaleId()
     * @uses GetPresales_Request::setPresaleName()
     * @uses GetPresales_Request::setSeriesId()
     * @param string $eventId
     * @param bool $includeAccessCodes
     * @param bool $includeAccessCodesCount
     * @param bool $includeAccessCodesTransactionCount
     * @param bool $includeInactive
     * @param string $presaleId
     * @param string $presaleName
     * @param string $seriesId
     */
    public function __construct($eventId = null, $includeAccessCodes = null, $includeAccessCodesCount = null, $includeAccessCodesTransactionCount = null, $includeInactive = null, $presaleId = null, $presaleName = null, $seriesId = null)
    {
        $this
            ->setEventId($eventId)
            ->setIncludeAccessCodes($includeAccessCodes)
            ->setIncludeAccessCodesCount($includeAccessCodesCount)
            ->setIncludeAccessCodesTransactionCount($includeAccessCodesTransactionCount)
            ->setIncludeInactive($includeInactive)
            ->setPresaleId($presaleId)
            ->setPresaleName($presaleName)
            ->setSeriesId($seriesId);
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\GetPresales_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IncludeAccessCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAccessCodes()
    {
        return isset($this->IncludeAccessCodes) ? $this->IncludeAccessCodes : null;
    }
    /**
     * Set IncludeAccessCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAccessCodes
     * @return \patest\StructType\GetPresales_Request
     */
    public function setIncludeAccessCodes($includeAccessCodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAccessCodes) && !is_bool($includeAccessCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAccessCodes, true), gettype($includeAccessCodes)), __LINE__);
        }
        if (is_null($includeAccessCodes) || (is_array($includeAccessCodes) && empty($includeAccessCodes))) {
            unset($this->IncludeAccessCodes);
        } else {
            $this->IncludeAccessCodes = $includeAccessCodes;
        }
        return $this;
    }
    /**
     * Get IncludeAccessCodesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAccessCodesCount()
    {
        return isset($this->IncludeAccessCodesCount) ? $this->IncludeAccessCodesCount : null;
    }
    /**
     * Set IncludeAccessCodesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAccessCodesCount
     * @return \patest\StructType\GetPresales_Request
     */
    public function setIncludeAccessCodesCount($includeAccessCodesCount = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAccessCodesCount) && !is_bool($includeAccessCodesCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAccessCodesCount, true), gettype($includeAccessCodesCount)), __LINE__);
        }
        if (is_null($includeAccessCodesCount) || (is_array($includeAccessCodesCount) && empty($includeAccessCodesCount))) {
            unset($this->IncludeAccessCodesCount);
        } else {
            $this->IncludeAccessCodesCount = $includeAccessCodesCount;
        }
        return $this;
    }
    /**
     * Get IncludeAccessCodesTransactionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAccessCodesTransactionCount()
    {
        return isset($this->IncludeAccessCodesTransactionCount) ? $this->IncludeAccessCodesTransactionCount : null;
    }
    /**
     * Set IncludeAccessCodesTransactionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAccessCodesTransactionCount
     * @return \patest\StructType\GetPresales_Request
     */
    public function setIncludeAccessCodesTransactionCount($includeAccessCodesTransactionCount = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAccessCodesTransactionCount) && !is_bool($includeAccessCodesTransactionCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAccessCodesTransactionCount, true), gettype($includeAccessCodesTransactionCount)), __LINE__);
        }
        if (is_null($includeAccessCodesTransactionCount) || (is_array($includeAccessCodesTransactionCount) && empty($includeAccessCodesTransactionCount))) {
            unset($this->IncludeAccessCodesTransactionCount);
        } else {
            $this->IncludeAccessCodesTransactionCount = $includeAccessCodesTransactionCount;
        }
        return $this;
    }
    /**
     * Get IncludeInactive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeInactive()
    {
        return isset($this->IncludeInactive) ? $this->IncludeInactive : null;
    }
    /**
     * Set IncludeInactive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeInactive
     * @return \patest\StructType\GetPresales_Request
     */
    public function setIncludeInactive($includeInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactive) && !is_bool($includeInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInactive, true), gettype($includeInactive)), __LINE__);
        }
        if (is_null($includeInactive) || (is_array($includeInactive) && empty($includeInactive))) {
            unset($this->IncludeInactive);
        } else {
            $this->IncludeInactive = $includeInactive;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleId()
    {
        return isset($this->PresaleId) ? $this->PresaleId : null;
    }
    /**
     * Set PresaleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleId
     * @return \patest\StructType\GetPresales_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        if (is_null($presaleId) || (is_array($presaleId) && empty($presaleId))) {
            unset($this->PresaleId);
        } else {
            $this->PresaleId = $presaleId;
        }
        return $this;
    }
    /**
     * Get PresaleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleName()
    {
        return isset($this->PresaleName) ? $this->PresaleName : null;
    }
    /**
     * Set PresaleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleName
     * @return \patest\StructType\GetPresales_Request
     */
    public function setPresaleName($presaleName = null)
    {
        // validation for constraint: string
        if (!is_null($presaleName) && !is_string($presaleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleName, true), gettype($presaleName)), __LINE__);
        }
        if (is_null($presaleName) || (is_array($presaleName) && empty($presaleName))) {
            unset($this->PresaleName);
        } else {
            $this->PresaleName = $presaleName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\GetPresales_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
